```toml
[advisory]
id = "RUSTSEC-2020-0019"
package = "tokio-rustls"
aliases = ["CVE-2020-35875", "GHSA-2jfv-g3fh-xq3v"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2020-05-19"
keywords = ["tls", "ssl", "DoS"]
url = "https://github.com/tokio-rs/tls/pull/14"

[versions]
patched = [">= 0.12.3, < 0.13.0", ">= 0.13.1"]
unaffected = ["< 0.12"]
```

# tokio-rustls reads may cause excessive memory usage

`tokio-rustls` does not call `process_new_packets` immediately after `read`,
so the expected termination condition `wants_read` always returns true.
As long as new incoming data arrives faster than it is processed
and the reader does not return pending, data will be buffered.

This may cause DoS.
