```toml
[advisory]
id = "RUSTSEC-2018-0002"
package = "tar"
aliases = ["CVE-2018-20990", "GHSA-2367-c296-3mp2"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N"
date = "2018-06-29"
keywords = ["file-overwrite"]
url = "https://github.com/alexcrichton/tar-rs/pull/156"

[versions]
patched = [">= 0.4.16"]
unaffected = []
```

# Links in archives can overwrite any existing file

When unpacking a tarball with the `unpack_in`-family of functions it's intended
that only files within the specified directory are able to be written. Tarballs
with hard links or symlinks, however, can be used to overwrite any file on the
filesystem.

Tarballs can contain multiple entries for the same file. A tarball which first
contains an entry for a hard link or symlink pointing to any file on the
filesystem will have the link created, and then afterwards if the same file is
listed in the tarball the hard link will be rewritten and any file can be
rewritten on the filesystem.

This has been fixed in https://github.com/alexcrichton/tar-rs/pull/156 and is
published as `tar` 0.4.16. Thanks to Max Justicz for discovering this and
emailing about the issue!
