```toml
[advisory]
id = "RUSTSEC-2020-0100"
package = "sys-info"
date = "2020-05-31"
url = "https://github.com/FillZpp/sys-info-rs/issues/63"
categories = ["memory-corruption"]
keywords = ["concurrency", "double free"]
aliases = ["CVE-2020-36434", "GHSA-2f5j-3mhq-xv58"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.8.0"]
unaffected = []

[affected]
os = ["linux"]
functions = { "sys_info::disk_info" = ["<= 0.1.1"] }
```

# Double free when calling `sys_info::disk_info` from multiple threads

Affected versions of `sys-info` use a static, global, list to store temporary disk information while running. The function that cleans up this list,
`DFCleanup`, assumes a single threaded environment and will try to free the same memory twice in a multithreaded environment.

This results in consistent double-frees and segfaults when calling `sys_info::disk_info` from multiple threads at once.

The issue was fixed by moving the global variable into a local scope.

## Safer Alternatives:
 - [`sysinfo`](https://crates.io/crates/sysinfo)
