```toml
[advisory]
id = "RUSTSEC-2020-0142"
package = "syncpool"
date = "2020-11-29"
url = "https://github.com/Chopinsky/byte_buffer/issues/2"
categories = ["memory-corruption"]
aliases = ["CVE-2020-36462", "GHSA-r88h-6987-g79f", "GHSA-vp6r-mrq9-8f4h"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.1.6"]
```

# Send bound needed on T (for Send impl of `Bucket2`)

Affected versions of this crate unconditionally implements `Send` for `Bucket2`. This allows sending non-Send types to other threads.

This can lead to data races when non Send types like `Cell<T>` or `Rc<T>` are contained inside `Bucket2` and sent across thread boundaries. The data races can potentially lead to memory corruption (as demonstrated in the PoC from the original report issue).

The flaw was corrected in commit 15b2828 by adding a `T: Send` bound to the `Send` impl of `Bucket2<T>`.
