```toml
[advisory]
id = "RUSTSEC-2020-0015"
package = "openssl-src"
aliases = ["CVE-2020-1967", "GHSA-jq65-29v4-4x35"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2020-04-25"
url = "https://www.openssl.org/news/secadv/20200421.txt"

[versions]
patched = [">= 111.9"]
unaffected = ["< 111.6"]
```

# Crash causing Denial of Service attack

Server or client applications that call the SSL_check_chain() function during or after a TLS 1.3 
handshake may crash due to a NULL pointer dereference as a result of incorrect handling of the 
"signature_algorithms_cert" TLS extension. The crash occurs if an invalid or unrecognised signature 
algorithm is received from the peer. This could be exploited by a malicious peer in a Denial of 
Service attack.
