```toml
[advisory]
id = "RUSTSEC-2024-0368"
package = "olm-sys"
date = "2024-09-02"
url = "https://gitlab.gnome.org/BrainBlasted/olm-sys/-/issues/12"
references = ["https://matrix.org/blog/2024/08/libolm-deprecation/"]
categories = ["crypto-failure"]
related = ["CVE-2024-45191", "CVE-2024-45192", "CVE-2024-45193"]

[versions]
patched = []
```

# olm-sys: wrapped library unmaintained, potentially vulnerable

After several cryptographic vulnerabilities in `libolm` were disclosed publicly, the Matrix Foundation has [officially deprecated the library](https://matrix.org/blog/2024/08/libolm-deprecation/). `olm-sys` is a thin wrapper around `libolm` and is now deprecated and potentially vulnerable in kind.

Users of `olm-sys` and its higher-level abstraction, `olm-rs`, are highly encouraged to switch to [`vodozemac`](https://crates.io/crates/vodozemac) as soon as possible. It is the successor effort to `libolm` and is written in Rust.
