```toml
[advisory]
id = "RUSTSEC-2021-0119"
package = "nix"
date = "2021-09-27"
url = "https://github.com/nix-rust/nix/issues/1541"
categories = ["memory-corruption"]
keywords = ["nss"]
aliases = ["CVE-2021-45707", "GHSA-76w9-p8mg-j927", "GHSA-wgrg-5h56-jg27"]

[versions]
patched = ["^0.20.2", "^0.21.2", "^0.22.2", ">= 0.23.0",]
unaffected = ["< 0.16.0"]

[affected]
os = ["linux", "freebsd", "android", "netbsd", "dragonfly", "openbsd", "fuchsia"]
functions = { "nix::unistd::getgrouplist" = [">= 0.16.0"] }
```

# Out-of-bounds write in nix::unistd::getgrouplist

On certain platforms, if a user has more than 16 groups, the
`nix::unistd::getgrouplist` function will call the libc `getgrouplist`
function with a length parameter greater than the size of the buffer it
provides, resulting in an out-of-bounds write and memory corruption.

The libc `getgrouplist` function takes an in/out parameter `ngroups`
specifying the size of the group buffer. When the buffer is too small to
hold all of the requested user's group memberships, some libc
implementations, including glibc and Solaris libc, will modify `ngroups`
to indicate the actual number of groups for the user, in addition to
returning an error. The version of `nix::unistd::getgrouplist` in nix
0.16.0 and up will resize the buffer to twice its size, but will not
read or modify the `ngroups` variable. Thus, if the user has more than
twice as many groups as the initial buffer size of 8, the next call to
`getgrouplist` will then write past the end of the buffer.

The issue would require editing /etc/groups to exploit, which is usually
only editable by the root user.
