```toml
[advisory]
id = "RUSTSEC-2021-0095"
package = "mopa"
date = "2021-06-01"
url = "https://github.com/chris-morgan/mopa/issues/13"
categories = ["memory-corruption", "memory-exposure", "code-execution"]
keywords = ["transmute", "dyn"]
informational = "unsound"
aliases = ["CVE-2021-45695", "GHSA-2gxj-qrp2-53jv", "GHSA-8mv5-7x95-7wcf"]

[versions]
patched = []
```

# `mopa` is technically unsound
The `mopa` crate redefines the deprecated `TraitObject` struct from `core::raw` like so:
```rust
#[repr(C)]
#[derive(Copy, Clone)]
#[doc(hidden)]
pub struct TraitObject {
    pub data: *mut (),
    pub vtable: *mut (),
}
```
This is done to then transmute a reference to a trait object (`&dyn Trait` for any trait `Trait`) into this struct and retrieve the `data` field for the purpose of downcasting. This is used to implement `downcast_ref_unchecked()`, in terms of which `downcast_ref()` is also implemented. Same goes for mutable reference downcasting and `Box` downcasting.

The Rust compiler explicitly reserves the right to change the memory layout of `&dyn Trait` for any trait `Trait`. The worst case scenario is that it swaps `data` and `vtable`, making an executable location breach and compromisation of ASLR possible, since reads from `data` would read `vtable` instead. Likewise, arbitrary code execution is also theoretically possible if reads of `vtable` generated by the compiler read `data` instead.

While, as of Rust 1.52, this unsound assumption still holds true, updating the compiler may silently create UB in a crate which previously compiled and run without issues, compromising the security of builds which are believed to be reproducible.

A potential strategy to resolve this has already been suggested in an issue on the GitHub repository of the crate.
