```toml
[advisory]
id = "RUSTSEC-2020-0073"
package = "image"
aliases = ["CVE-2020-35916", "GHSA-9wgh-vjj7-7433"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-12"
url = "https://github.com/image-rs/image/issues/1357"
informational = "unsound"
keywords = ["pointer", "cast", "provenance"]

[versions]
patched = [">= 0.23.12"]

[affected.functions]
"image::Bgr::from_slice_mut" = ["< 0.23.12"]
"image::Bgra::from_slice_mut" = ["< 0.23.12"]
"image::Luma::from_slice_mut" = ["< 0.23.12"]
"image::LumaA::from_slice_mut" = ["< 0.23.12"]
"image::Rgb::from_slice_mut" = ["< 0.23.12"]
"image::Rgba::from_slice_mut" = ["< 0.23.12"]
```

# Mutable reference with immutable provenance

A mutable reference to a struct was constructed by dereferencing a pointer
obtained from `slice::as_ptr`. Instead, `slice::as_mut_ptr` should have been
called on the mutable slice argument. The former performs an implicit reborrow
as an immutable shared reference which does not allow writing through the
derived pointer.

There is no evidence for miscompilation, exploitable or otherwise, caused by
this bug. [Further investigation on Zulip][Zulip] suggests that the unoptimized
generated LLVM IR does not contain any UB itself, effectively mitigating
further effects.

[Zulip]: https://rust-lang.zulipchat.com/#narrow/stream/146229-wg-secure-code/topic/Implications.20of.20using.20.60slice.3A.3Aas_ptr.60.20for.20mutable.20access/near/216499472
