```toml
[advisory]
id = "RUSTSEC-2021-0079"
package = "hyper"
date = "2021-07-07"
url = "https://github.com/hyperium/hyper/security/advisories/GHSA-5h46-h7hh-c6x9"
keywords = ["http", "parsing", "data loss"]
aliases = ["CVE-2021-32714", "GHSA-5h46-h7hh-c6x9"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H"

[versions]
patched = [">= 0.14.10"]
```

# Integer overflow in `hyper`'s parsing of the `Transfer-Encoding` header leads to data loss

When decoding chunk sizes that are too large, `hyper`'s code would encounter an integer overflow. Depending on the situation,
this could lead to data loss from an incorrect total size, or in rarer cases, a request smuggling attack.

To be vulnerable, you must be using `hyper` for any HTTP/1 purpose, including as a client or server, and consumers must send
requests or responses that specify a chunk size greater than 18 exabytes. For a possible request smuggling attack to be possible,
any upstream proxies must accept a chunk size greater than 64 bits.
