```toml
[advisory]
id = "RUSTSEC-2023-0002"
package = "git2"
date = "2023-01-12"
url = "https://github.com/rust-lang/git2-rs/pull/909"
references = ["https://blog.rust-lang.org/2023/01/10/cve-2022-46176.html"]
categories = ["crypto-failure"]
keywords = ["cargo", "ssh", "mitm"]
withdrawn = "2023-01-13"

[versions]
patched = [">= 0.16.0"]
```

# git2 Rust package suppresses ssh host key checking

By default, when accessing an ssh repository
(ie via an `ssh:` git repository url)
the git2 Rust package does not do any host key checking.

Additionally,
the provided API is not sufficient for a an application
to do meaningful checking itself.

## Impact

When connecting to an ssh repository,
and when an attacker can redirect the connection
(performing a malice-in-the-middle attack)
an affected application might:

 * Receive git objects and branches controlled by the attacker,
   exposing the local system (and whatever happens next)
   to malicious data.
   In many circumstances,
   this could readily lead to privilege escalation.

 * Erroneously send git objects to the attacker,
   rather than to the intended recipient.
   If the information is not supposed to be public,
   this would constitute an information leak.
   Also, since the data doesn't arrive where intended,
   it constitutes a denial of service.

## Technical details

The `git2` Rust package (henceforth, git2-rs)
unconditionally calls the underlying C `libgit2` functions to set
an ssh certificate check callback.
The Rust package uses this to offer
the ability for the application to set a callback to a Rust function.

The C-level callback function provided by git2-rs 0.15.0 and earlier:

 * Always ignores the `is_valid` argument provided by `libgit2`,
   which indicates whether `libgit2` considers the host key valid

 * By default, performs no checks, and then
   returns code `0`,
   indicating to `libgit2` to override `libgit2`'s determination
   and treat the host key as valid.

 * Provides only limited APIs to the application
   for examining the supplied host key,
   and doesn't tell the application
   whether `libgit2`'s checks succeeded,
   so it is difficult for the application cannot work around the problem.

## Resolution

Upgrade to git2-rs 0.16.x.

The default behaviour in 0.16.x is to
honour `libgit2`'s validity determination.

Note that adding this previously skipped check
may cause existing setups to stop working.

## Relationship to CVE-2022-46176

This bug manifested in cargo where it was assigned CVE-2022-46176.

The same bug exists in other applications which use
affected versions of git2-rs
unless they never try to access git repositories with `ssh:` urls.
