```toml
[advisory]
id = "RUSTSEC-2020-0151"
package = "generator"
aliases = ["CVE-2020-36471", "GHSA-w3g5-2848-2v8r"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-16"
url = "https://github.com/Xudong-Huang/generator-rs/issues/27"
categories = ["memory-corruption"]
keywords = ["concurrency"]

[versions]
patched = [">= 0.7.0"]
```

# Generators can cause data races if non-Send types are used in their generator functions

The `Generator` type is an iterable which uses a generator function that yields
values. In affected versions of the crate, the provided function yielding values
had no `Send` bounds despite the `Generator` itself implementing `Send`.

The generator function lacking a `Send` bound means that types that are
dangerous to send across threads such as `Rc` could be sent as part of a
generator, potentially leading to data races.

This flaw was fixed in commit [`f7d120a3b`](https://github.com/Xudong-Huang/generator-rs/commit/f7d120a3b724d06a7b623d0a4306acf8f78cb4f0)
by enforcing that the generator function be bound by `Send`.
