```toml
[advisory]
id = "RUSTSEC-2020-0050"
package = "dync"
aliases = ["CVE-2020-35903", "GHSA-qxjq-v4wf-ppvh"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-09-27"
informational = "unsound"
url = "https://github.com/elrnv/dync/issues/4"

[versions]
patched = [">= 0.5.0"]
```

# VecCopy allows misaligned access to elements

`VecCopy::data` is created as a Vec of u8 but can be used to store and retrieve
elements of different types leading to misaligned access.

The issue was resolved in v0.5.0 by replacing data being stored by `Vec<u8>` with a custom managed
pointer.  Elements are now stored and retrieved using types with proper alignment corresponding to
original types.
