```toml
[advisory]
id = "RUSTSEC-2024-0018"
package = "crayon"
date = "2024-02-27"
url = "https://github.com/shawnscode/crayon/issues/109"
categories = ["memory-corruption"]
keywords = ["std::mem::uninitialized", "address-sanitizer"]
aliases = ["GHSA-xfhw-6mc4-mgxf"]

[versions]
patched = []
unaffected = ["< 0.6.0"]
[affected]
functions = { "crayon::utils::object_pool::ObjectPool<H,T>::free" = [">=0.6.0"] }
```

# ObjectPool creates uninitialized memory when freeing objects

As of version 0.6.0, the ObjectPool explicitly creates an uninitialized instance of its
type parameter when it attempts to free an object, and swaps it into the storage. This
causes instant undefined behavior due to reading the uninitialized memory in order to
write it to the pool storage.

Extremely basic usage of the crate can trigger this issue, e.g. this code from a doctest:

```rust
use crayon::prelude::*;
application::oneshot().unwrap();

let mut params = MeshParams::default();

let mesh = video::create_mesh(params, None).unwrap();

// Deletes the mesh object.
video::delete_mesh(mesh); // <-- UB
```

The Clippy warning for this code was silenced in commit c2fde19caf6149d91faa504263f0bc5cafc35de5.

Discovered via https://asan.saethlin.dev/ub?crate=crayon&version=0.7.1
