```toml
[advisory]
id = "RUSTSEC-2021-0007"
package = "av-data"
aliases = ["CVE-2021-25904", "GHSA-352p-rhvq-7g78"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2021-01-07"
url = "https://github.com/rust-av/rust-av/issues/136"
categories = ["memory-exposure", "privilege-escalation"]

[versions]
patched = [">= 0.3.0"]
```

# `Frame::copy_from_raw_parts` can lead to segfault without `unsafe`

`fn Frame::copy_from_raw_parts()` is a safe API that can take a
raw pointer and dereference it. It is possible to read arbitrary memory address
with an arbitrarily fed pointer. This allows the safe API to access & read
arbitrary address in memory. Feeding an invalid memory address pointer to
the API may also cause the program to segfault.

The flaw was corrected in https://github.com/rust-av/rust-av/pull/137,
by removing the API `fn Frame::copy_from_raw_parts()`.

