```toml
[advisory]
id = "RUSTSEC-2020-0103"
package = "autorand"
aliases = ["CVE-2020-36210", "GHSA-cgmg-2v6m-fjg7"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H"
date = "2020-12-31"
url = "https://github.com/mersinvald/autorand-rs/issues/5"
categories = ["memory-corruption"]

[versions]
patched = [">= 0.2.3"]
```

# `impl Random` on arrays can lead to dropping uninitialized memory

Affected versions of this crate had a panic safety issue to drop partially uninitialized array of `T` upon panic in a user provided function `T::random()`. Dropping uninitialized `T` can potentially cause memory corruption or undefined behavior.

The flaw was corrected in commit 565d508 by using `MaybeUninit<T>` to avoid possible dropping of uninitialized memory upon panic.
