package parser

// Autogenerated code from ntfs_profile.json. Do not edit.

import (
	"bytes"
	"encoding/binary"
	"fmt"
	"io"
	"sort"
	"strings"
	"unicode/utf16"
	"unicode/utf8"
)

var (
	// Depending on autogenerated code we may use this. Add a reference
	// to shut the compiler up.
	_ = bytes.MinRead
	_ = fmt.Sprintf
	_ = utf16.Decode
	_ = binary.LittleEndian
	_ = utf8.RuneError
	_ = sort.Strings
	_ = strings.Join
	_ = io.Copy
)

func indent(text string) string {
	result := []string{}
	lines := strings.Split(text, "\n")
	for _, line := range lines {
		result = append(result, "  "+line)
	}
	return strings.Join(result, "\n")
}

type NTFSProfile struct {
	Off_ATTRIBUTE_LIST_ENTRY_Type                       int64
	Off_ATTRIBUTE_LIST_ENTRY_Length                     int64
	Off_ATTRIBUTE_LIST_ENTRY_Name_length                int64
	Off_ATTRIBUTE_LIST_ENTRY_Offset_to_name             int64
	Off_ATTRIBUTE_LIST_ENTRY_Starting_vcn               int64
	Off_ATTRIBUTE_LIST_ENTRY_MftReference               int64
	Off_ATTRIBUTE_LIST_ENTRY_Attribute_id               int64
	Off_FILE_NAME_MftReference                          int64
	Off_FILE_NAME_Seq_num                               int64
	Off_FILE_NAME_Created                               int64
	Off_FILE_NAME_File_modified                         int64
	Off_FILE_NAME_Mft_modified                          int64
	Off_FILE_NAME_File_accessed                         int64
	Off_FILE_NAME_Allocated_size                        int64
	Off_FILE_NAME_FilenameSize                          int64
	Off_FILE_NAME_Flags                                 int64
	Off_FILE_NAME_Reparse_value                         int64
	Off_FILE_NAME__length_of_name                       int64
	Off_FILE_NAME_NameType                              int64
	Off_FILE_NAME_name                                  int64
	Off_GUID_Data1                                      int64
	Off_GUID_Data2                                      int64
	Off_GUID_Data3                                      int64
	Off_GUID_Data4                                      int64
	Off_INDEX_NODE_HEADER_Offset_to_index_entry         int64
	Off_INDEX_NODE_HEADER_Offset_to_end_index_entry     int64
	Off_INDEX_NODE_HEADER_SizeOfEntriesAlloc            int64
	Off_INDEX_RECORD_ENTRY_MftReference                 int64
	Off_INDEX_RECORD_ENTRY_Seq_num                      int64
	Off_INDEX_RECORD_ENTRY_SizeOfIndexEntry             int64
	Off_INDEX_RECORD_ENTRY_FilenameOffset               int64
	Off_INDEX_RECORD_ENTRY_Flags                        int64
	Off_INDEX_RECORD_ENTRY_File                         int64
	Off_INDEX_ROOT_Type                                 int64
	Off_INDEX_ROOT_Collation_rule                       int64
	Off_INDEX_ROOT_Idxalloc_size_b                      int64
	Off_INDEX_ROOT_Idx_size_c                           int64
	Off_INDEX_ROOT_Node                                 int64
	Off_MFT_ENTRY_Magic                                 int64
	Off_MFT_ENTRY_Fixup_offset                          int64
	Off_MFT_ENTRY_Fixup_count                           int64
	Off_MFT_ENTRY_Logfile_sequence_number               int64
	Off_MFT_ENTRY_Sequence_value                        int64
	Off_MFT_ENTRY_Link_count                            int64
	Off_MFT_ENTRY_Attribute_offset                      int64
	Off_MFT_ENTRY_Flags                                 int64
	Off_MFT_ENTRY_Mft_entry_size                        int64
	Off_MFT_ENTRY_Mft_entry_allocated                   int64
	Off_MFT_ENTRY_Base_record_reference                 int64
	Off_MFT_ENTRY_Next_attribute_id                     int64
	Off_MFT_ENTRY_Record_number                         int64
	Off_NTFS_ATTRIBUTE_Type                             int64
	Off_NTFS_ATTRIBUTE_Length                           int64
	Off_NTFS_ATTRIBUTE_Resident                         int64
	Off_NTFS_ATTRIBUTE_name_length                      int64
	Off_NTFS_ATTRIBUTE_name_offset                      int64
	Off_NTFS_ATTRIBUTE_Flags                            int64
	Off_NTFS_ATTRIBUTE_Attribute_id                     int64
	Off_NTFS_ATTRIBUTE_Content_size                     int64
	Off_NTFS_ATTRIBUTE_Content_offset                   int64
	Off_NTFS_ATTRIBUTE_Runlist_vcn_start                int64
	Off_NTFS_ATTRIBUTE_Runlist_vcn_end                  int64
	Off_NTFS_ATTRIBUTE_Runlist_offset                   int64
	Off_NTFS_ATTRIBUTE_Compression_unit_size            int64
	Off_NTFS_ATTRIBUTE_Allocated_size                   int64
	Off_NTFS_ATTRIBUTE_Actual_size                      int64
	Off_NTFS_ATTRIBUTE_Initialized_size                 int64
	Off_NTFS_BOOT_SECTOR_Oemname                        int64
	Off_NTFS_BOOT_SECTOR_Sector_size                    int64
	Off_NTFS_BOOT_SECTOR__cluster_size                  int64
	Off_NTFS_BOOT_SECTOR__volume_size                   int64
	Off_NTFS_BOOT_SECTOR__mft_cluster                   int64
	Off_NTFS_BOOT_SECTOR__mirror_mft_cluster            int64
	Off_NTFS_BOOT_SECTOR__mft_record_size               int64
	Off_NTFS_BOOT_SECTOR_Index_record_size              int64
	Off_NTFS_BOOT_SECTOR_Serial                         int64
	Off_NTFS_BOOT_SECTOR_Magic                          int64
	Off_NTFS_RESIDENT_ATTRIBUTE_Type                    int64
	Off_NTFS_RESIDENT_ATTRIBUTE_Length                  int64
	Off_NTFS_RESIDENT_ATTRIBUTE_Resident                int64
	Off_NTFS_RESIDENT_ATTRIBUTE_Name_length             int64
	Off_NTFS_RESIDENT_ATTRIBUTE_Name_offset             int64
	Off_NTFS_RESIDENT_ATTRIBUTE_Attribute_id            int64
	Off_NTFS_RESIDENT_ATTRIBUTE_content_size            int64
	Off_NTFS_RESIDENT_ATTRIBUTE_content_offset          int64
	Off_STANDARD_INDEX_HEADER_MagicNumber               int64
	Off_STANDARD_INDEX_HEADER_Fixup_offset              int64
	Off_STANDARD_INDEX_HEADER_Fixup_count               int64
	Off_STANDARD_INDEX_HEADER_LogFileSeqNum             int64
	Off_STANDARD_INDEX_HEADER_VcnOfINDX                 int64
	Off_STANDARD_INDEX_HEADER_Node                      int64
	Off_STANDARD_INFORMATION_Create_time                int64
	Off_STANDARD_INFORMATION_File_altered_time          int64
	Off_STANDARD_INFORMATION_Mft_altered_time           int64
	Off_STANDARD_INFORMATION_File_accessed_time         int64
	Off_STANDARD_INFORMATION_Flags                      int64
	Off_STANDARD_INFORMATION_Max_versions               int64
	Off_STANDARD_INFORMATION_Version                    int64
	Off_STANDARD_INFORMATION_Class_id                   int64
	Off_STANDARD_INFORMATION_Owner_id                   int64
	Off_STANDARD_INFORMATION_Sid                        int64
	Off_STANDARD_INFORMATION_Quota                      int64
	Off_STANDARD_INFORMATION_Usn                        int64
	Off_USN_RECORD_V2_RecordLength                      int64
	Off_USN_RECORD_V2_MajorVersion                      int64
	Off_USN_RECORD_V2_MinorVersion                      int64
	Off_USN_RECORD_V2_FileReferenceNumberSequence       int64
	Off_USN_RECORD_V2_FileReferenceNumberID             int64
	Off_USN_RECORD_V2_ParentFileReferenceNumberSequence int64
	Off_USN_RECORD_V2_ParentFileReferenceNumberID       int64
	Off_USN_RECORD_V2_Usn                               int64
	Off_USN_RECORD_V2_TimeStamp                         int64
	Off_USN_RECORD_V2_Reason                            int64
	Off_USN_RECORD_V2_SourceInfo                        int64
	Off_USN_RECORD_V2_SecurityId                        int64
	Off_USN_RECORD_V2_FileAttributes                    int64
	Off_USN_RECORD_V2_FileNameLength                    int64
	Off_USN_RECORD_V2_FileNameOffset                    int64
	Off_VSS_CATALOG_ENTRY_1_EntryType                   int64
	Off_VSS_CATALOG_ENTRY_2_EntryType                   int64
	Off_VSS_CATALOG_ENTRY_2_VolumeSize                  int64
	Off_VSS_CATALOG_ENTRY_2_StoreGUID                   int64
	Off_VSS_CATALOG_ENTRY_2_CreationTime                int64
	Off_VSS_CATALOG_ENTRY_3_EntryType                   int64
	Off_VSS_CATALOG_ENTRY_3_StoreBlockListOffset        int64
	Off_VSS_CATALOG_ENTRY_3_StoreGUID                   int64
	Off_VSS_CATALOG_ENTRY_3_StoreHeaderOffset           int64
	Off_VSS_CATALOG_ENTRY_3_StoreBlockRangeListOffset   int64
	Off_VSS_CATALOG_ENTRY_3_StoreBitmapOffset           int64
	Off_VSS_CATALOG_ENTRY_3_NTFSFileReference           int64
	Off_VSS_CATALOG_ENTRY_3_AllocatedSize               int64
	Off_VSS_CATALOG_ENTRY_3_StorePreviousBitmapOffset   int64
	Off_VSS_CATALOG_HEADER_Identifier                   int64
	Off_VSS_CATALOG_HEADER_Version                      int64
	Off_VSS_CATALOG_HEADER_RecordType                   int64
	Off_VSS_CATALOG_HEADER_RelativeOffset               int64
	Off_VSS_CATALOG_HEADER_CurrentOffset                int64
	Off_VSS_CATALOG_HEADER_NextOffset                   int64
	Off_VSS_STORE_BLOCK_HEADER_Identifier               int64
	Off_VSS_STORE_BLOCK_HEADER_Version                  int64
	Off_VSS_STORE_BLOCK_HEADER_RecordType               int64
	Off_VSS_STORE_BLOCK_HEADER_RelativeOffset           int64
	Off_VSS_STORE_BLOCK_HEADER_CurrentOffset            int64
	Off_VSS_STORE_BLOCK_HEADER_NextOffset               int64
	Off_VSS_STORE_BLOCK_HEADER_SizeOfStore              int64
	Off_VSS_STORE_INFORMATION_ShadowCopyGUID            int64
	Off_VSS_STORE_INFORMATION_ShadowCopySetGUID         int64
	Off_VSS_STORE_INFORMATION_SnapshotContext           int64
	Off_VSS_STORE_INFORMATION_AttributeFlags            int64
	Off_VSS_VOLUME_HEADER_Identifier                    int64
	Off_VSS_VOLUME_HEADER_Version                       int64
	Off_VSS_VOLUME_HEADER_RecordType                    int64
	Off_VSS_VOLUME_HEADER_CurrentOffset                 int64
	Off_VSS_VOLUME_HEADER_CatalogOffset                 int64
	Off_VSS_VOLUME_HEADER_MaxSize                       int64
	Off_VSS_VOLUME_HEADER_VolumeGUID                    int64
	Off_VSS_VOLUME_HEADER_ShadowVolumeGUID              int64
}

func NewNTFSProfile() *NTFSProfile {
	// Specific offsets can be tweaked to cater for slight version mismatches.
	self := &NTFSProfile{0, 4, 6, 7, 8, 16, 24, 0, 6, 8, 16, 24, 32, 40, 48, 56, 60, 64, 65, 66, 0, 4, 6, 8, 0, 4, 8, 0, 6, 8, 10, 12, 16, 0, 4, 8, 12, 16, 0, 4, 6, 8, 16, 18, 20, 22, 24, 28, 32, 40, 44, 0, 4, 8, 9, 10, 12, 14, 16, 20, 16, 24, 32, 34, 40, 48, 56, 3, 11, 13, 40, 48, 56, 64, 68, 72, 510, 0, 4, 8, 9, 10, 14, 16, 20, 0, 4, 6, 8, 16, 24, 0, 8, 16, 24, 32, 36, 40, 44, 48, 52, 56, 64, 0, 4, 6, 8, 8, 16, 16, 24, 32, 40, 44, 48, 52, 56, 58, 0, 0, 8, 16, 48, 0, 8, 16, 32, 40, 48, 56, 64, 72, 0, 16, 20, 24, 32, 40, 0, 16, 20, 24, 32, 40, 48, 16, 32, 48, 56, 0, 16, 20, 24, 48, 56, 64, 80}
	return self
}

func (self *NTFSProfile) ATTRIBUTE_LIST_ENTRY(reader io.ReaderAt, offset int64) *ATTRIBUTE_LIST_ENTRY {
	STATS.Inc_ATTRIBUTE_LIST_ENTRY()
	return &ATTRIBUTE_LIST_ENTRY{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) FILE_NAME(reader io.ReaderAt, offset int64) *FILE_NAME {
	STATS.Inc_FILE_NAME()
	return &FILE_NAME{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) GUID(reader io.ReaderAt, offset int64) *GUID {
	return &GUID{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) INDEX_NODE_HEADER(reader io.ReaderAt, offset int64) *INDEX_NODE_HEADER {
	return &INDEX_NODE_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) INDEX_RECORD_ENTRY(reader io.ReaderAt, offset int64) *INDEX_RECORD_ENTRY {
	return &INDEX_RECORD_ENTRY{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) INDEX_ROOT(reader io.ReaderAt, offset int64) *INDEX_ROOT {
	return &INDEX_ROOT{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) MFT_ENTRY(reader io.ReaderAt, offset int64) *MFT_ENTRY {
	STATS.Inc_MFT_ENTRY()
	return &MFT_ENTRY{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) NTFS_ATTRIBUTE(reader io.ReaderAt, offset int64) *NTFS_ATTRIBUTE {
	STATS.Inc_NTFS_ATTRIBUTE()
	return NewNTFS_ATTRIBUTE(reader, offset, self)
}

func (self *NTFSProfile) NTFS_BOOT_SECTOR(reader io.ReaderAt, offset int64) *NTFS_BOOT_SECTOR {
	return &NTFS_BOOT_SECTOR{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) NTFS_RESIDENT_ATTRIBUTE(reader io.ReaderAt, offset int64) *NTFS_RESIDENT_ATTRIBUTE {
	return &NTFS_RESIDENT_ATTRIBUTE{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) STANDARD_INDEX_HEADER(reader io.ReaderAt, offset int64) *STANDARD_INDEX_HEADER {
	return &STANDARD_INDEX_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) STANDARD_INFORMATION(reader io.ReaderAt, offset int64) *STANDARD_INFORMATION {
	STATS.Inc_STANDARD_INFORMATION()
	return &STANDARD_INFORMATION{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) USN_RECORD_V2(reader io.ReaderAt, offset int64) *USN_RECORD_V2 {
	return &USN_RECORD_V2{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_CATALOG_ENTRY_1(reader io.ReaderAt, offset int64) *VSS_CATALOG_ENTRY_1 {
	return &VSS_CATALOG_ENTRY_1{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_CATALOG_ENTRY_2(reader io.ReaderAt, offset int64) *VSS_CATALOG_ENTRY_2 {
	return &VSS_CATALOG_ENTRY_2{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_CATALOG_ENTRY_3(reader io.ReaderAt, offset int64) *VSS_CATALOG_ENTRY_3 {
	return &VSS_CATALOG_ENTRY_3{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_CATALOG_HEADER(reader io.ReaderAt, offset int64) *VSS_CATALOG_HEADER {
	return &VSS_CATALOG_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_STORE_BLOCK_HEADER(reader io.ReaderAt, offset int64) *VSS_STORE_BLOCK_HEADER {
	return &VSS_STORE_BLOCK_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_STORE_INFORMATION(reader io.ReaderAt, offset int64) *VSS_STORE_INFORMATION {
	return &VSS_STORE_INFORMATION{Reader: reader, Offset: offset, Profile: self}
}

func (self *NTFSProfile) VSS_VOLUME_HEADER(reader io.ReaderAt, offset int64) *VSS_VOLUME_HEADER {
	return &VSS_VOLUME_HEADER{Reader: reader, Offset: offset, Profile: self}
}

type ATTRIBUTE_LIST_ENTRY struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *ATTRIBUTE_LIST_ENTRY) Size() int {
	return 0
}

func (self *ATTRIBUTE_LIST_ENTRY) Type() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_Type+self.Offset)
}

func (self *ATTRIBUTE_LIST_ENTRY) Length() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_Length+self.Offset)
}

func (self *ATTRIBUTE_LIST_ENTRY) Name_length() byte {
	return ParseUint8(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_Name_length+self.Offset)
}

func (self *ATTRIBUTE_LIST_ENTRY) Offset_to_name() byte {
	return ParseUint8(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_Offset_to_name+self.Offset)
}

func (self *ATTRIBUTE_LIST_ENTRY) Starting_vcn() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_Starting_vcn+self.Offset)
}

func (self *ATTRIBUTE_LIST_ENTRY) MftReference() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_MftReference+self.Offset)
	return (uint64(value) & 0xffffffffffff) >> 0x0
}

func (self *ATTRIBUTE_LIST_ENTRY) Attribute_id() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_ATTRIBUTE_LIST_ENTRY_Attribute_id+self.Offset)
}
func (self *ATTRIBUTE_LIST_ENTRY) DebugString() string {
	result := fmt.Sprintf("struct ATTRIBUTE_LIST_ENTRY @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Type: %#0x\n", self.Type())
	result += fmt.Sprintf("  Length: %#0x\n", self.Length())
	result += fmt.Sprintf("  Name_length: %#0x\n", self.Name_length())
	result += fmt.Sprintf("  Offset_to_name: %#0x\n", self.Offset_to_name())
	result += fmt.Sprintf("  Starting_vcn: %#0x\n", self.Starting_vcn())
	result += fmt.Sprintf("  MftReference: %#0x\n", self.MftReference())
	result += fmt.Sprintf("  Attribute_id: %#0x\n", self.Attribute_id())
	return result
}

type FILE_NAME struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *FILE_NAME) Size() int {
	return 66
}

func (self *FILE_NAME) MftReference() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_FILE_NAME_MftReference+self.Offset)
	return (uint64(value) & 0xffffffffffff) >> 0x0
}

func (self *FILE_NAME) Seq_num() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_FILE_NAME_Seq_num+self.Offset)
}

func (self *FILE_NAME) Created() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_FILE_NAME_Created+self.Offset)
}

func (self *FILE_NAME) File_modified() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_FILE_NAME_File_modified+self.Offset)
}

func (self *FILE_NAME) Mft_modified() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_FILE_NAME_Mft_modified+self.Offset)
}

func (self *FILE_NAME) File_accessed() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_FILE_NAME_File_accessed+self.Offset)
}

func (self *FILE_NAME) Allocated_size() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_FILE_NAME_Allocated_size+self.Offset)
}

func (self *FILE_NAME) FilenameSize() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_FILE_NAME_FilenameSize+self.Offset)
}

func (self *FILE_NAME) Flags() *Flags {
	value := ParseUint32(self.Reader, self.Profile.Off_FILE_NAME_Flags+self.Offset)
	names := make(map[string]bool)

	if value&1024 != 0 {
		names["REPARSE_POINT"] = true
	}

	if value&4096 != 0 {
		names["OFFLINE"] = true
	}

	if value&1 != 0 {
		names["READ_ONLY"] = true
	}

	if value&4 != 0 {
		names["SYSTEM"] = true
	}

	if value&64 != 0 {
		names["DEVICE"] = true
	}

	if value&256 != 0 {
		names["TEMPORARY"] = true
	}

	if value&512 != 0 {
		names["SPARSE"] = true
	}

	if value&16384 != 0 {
		names["ENCRYPTED"] = true
	}

	if value&2 != 0 {
		names["HIDDEN"] = true
	}

	if value&32 != 0 {
		names["ARCHIVE"] = true
	}

	if value&128 != 0 {
		names["NORMAL"] = true
	}

	if value&2048 != 0 {
		names["COMPRESSED"] = true
	}

	if value&8192 != 0 {
		names["NOT_INDEXED"] = true
	}

	return &Flags{Value: uint64(value), Names: names}
}

func (self *FILE_NAME) Reparse_value() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_FILE_NAME_Reparse_value+self.Offset)
}

func (self *FILE_NAME) _length_of_name() byte {
	return ParseUint8(self.Reader, self.Profile.Off_FILE_NAME__length_of_name+self.Offset)
}

func (self *FILE_NAME) NameType() *Enumeration {
	value := ParseUint8(self.Reader, self.Profile.Off_FILE_NAME_NameType+self.Offset)
	name := "Unknown"
	switch value {

	case 0:
		name = "POSIX"

	case 1:
		name = "Win32"

	case 2:
		name = "DOS"

	case 3:
		name = "DOS+Win32"
	}
	return &Enumeration{Value: uint64(value), Name: name}
}

func (self *FILE_NAME) name() string {
	return ParseTerminatedUTF16String(self.Reader, self.Profile.Off_FILE_NAME_name+self.Offset)
}
func (self *FILE_NAME) DebugString() string {
	result := fmt.Sprintf("struct FILE_NAME @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  MftReference: %#0x\n", self.MftReference())
	result += fmt.Sprintf("  Seq_num: %#0x\n", self.Seq_num())
	result += fmt.Sprintf("  Created: {\n%v}\n", indent(self.Created().DebugString()))
	result += fmt.Sprintf("  File_modified: {\n%v}\n", indent(self.File_modified().DebugString()))
	result += fmt.Sprintf("  Mft_modified: {\n%v}\n", indent(self.Mft_modified().DebugString()))
	result += fmt.Sprintf("  File_accessed: {\n%v}\n", indent(self.File_accessed().DebugString()))
	result += fmt.Sprintf("  Allocated_size: %#0x\n", self.Allocated_size())
	result += fmt.Sprintf("  FilenameSize: %#0x\n", self.FilenameSize())
	result += fmt.Sprintf("  Flags: %v\n", self.Flags().DebugString())
	result += fmt.Sprintf("  Reparse_value: %#0x\n", self.Reparse_value())
	result += fmt.Sprintf("  _length_of_name: %#0x\n", self._length_of_name())
	result += fmt.Sprintf("  NameType: %v\n", self.NameType().DebugString())
	result += fmt.Sprintf("  name: %v\n", string(self.name()))
	return result
}

type GUID struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *GUID) Size() int {
	return 16
}

func (self *GUID) Data1() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_GUID_Data1+self.Offset)
}

func (self *GUID) Data2() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_GUID_Data2+self.Offset)
}

func (self *GUID) Data3() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_GUID_Data3+self.Offset)
}

func (self *GUID) Data4() []byte {
	return ParseArray_byte(self.Profile, self.Reader, self.Profile.Off_GUID_Data4+self.Offset, 8)
}
func (self *GUID) DebugString() string {
	result := fmt.Sprintf("struct GUID @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Data1: %#0x\n", self.Data1())
	result += fmt.Sprintf("  Data2: %#0x\n", self.Data2())
	result += fmt.Sprintf("  Data3: %#0x\n", self.Data3())
	return result
}

type INDEX_NODE_HEADER struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *INDEX_NODE_HEADER) Size() int {
	return 16
}

func (self *INDEX_NODE_HEADER) Offset_to_index_entry() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_NODE_HEADER_Offset_to_index_entry+self.Offset)
}

func (self *INDEX_NODE_HEADER) Offset_to_end_index_entry() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_NODE_HEADER_Offset_to_end_index_entry+self.Offset)
}

func (self *INDEX_NODE_HEADER) SizeOfEntriesAlloc() int32 {
	return ParseInt32(self.Reader, self.Profile.Off_INDEX_NODE_HEADER_SizeOfEntriesAlloc+self.Offset)
}
func (self *INDEX_NODE_HEADER) DebugString() string {
	result := fmt.Sprintf("struct INDEX_NODE_HEADER @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Offset_to_index_entry: %#0x\n", self.Offset_to_index_entry())
	result += fmt.Sprintf("  Offset_to_end_index_entry: %#0x\n", self.Offset_to_end_index_entry())
	result += fmt.Sprintf("  SizeOfEntriesAlloc: %#0x\n", self.SizeOfEntriesAlloc())
	return result
}

type INDEX_RECORD_ENTRY struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *INDEX_RECORD_ENTRY) Size() int {
	return 0
}

func (self *INDEX_RECORD_ENTRY) MftReference() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_INDEX_RECORD_ENTRY_MftReference+self.Offset)
	return (uint64(value) & 0xffffffffffff) >> 0x0
}

func (self *INDEX_RECORD_ENTRY) Seq_num() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_INDEX_RECORD_ENTRY_Seq_num+self.Offset)
}

func (self *INDEX_RECORD_ENTRY) SizeOfIndexEntry() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_INDEX_RECORD_ENTRY_SizeOfIndexEntry+self.Offset)
}

func (self *INDEX_RECORD_ENTRY) FilenameOffset() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_INDEX_RECORD_ENTRY_FilenameOffset+self.Offset)
}

func (self *INDEX_RECORD_ENTRY) Flags() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_RECORD_ENTRY_Flags+self.Offset)
}

func (self *INDEX_RECORD_ENTRY) File() *FILE_NAME {
	return self.Profile.FILE_NAME(self.Reader, self.Profile.Off_INDEX_RECORD_ENTRY_File+self.Offset)
}
func (self *INDEX_RECORD_ENTRY) DebugString() string {
	result := fmt.Sprintf("struct INDEX_RECORD_ENTRY @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  MftReference: %#0x\n", self.MftReference())
	result += fmt.Sprintf("  Seq_num: %#0x\n", self.Seq_num())
	result += fmt.Sprintf("  SizeOfIndexEntry: %#0x\n", self.SizeOfIndexEntry())
	result += fmt.Sprintf("  FilenameOffset: %#0x\n", self.FilenameOffset())
	result += fmt.Sprintf("  Flags: %#0x\n", self.Flags())
	result += fmt.Sprintf("  File: {\n%v}\n", indent(self.File().DebugString()))
	return result
}

type INDEX_ROOT struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *INDEX_ROOT) Size() int {
	return 0
}

func (self *INDEX_ROOT) Type() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_ROOT_Type+self.Offset)
}

func (self *INDEX_ROOT) Collation_rule() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_ROOT_Collation_rule+self.Offset)
}

func (self *INDEX_ROOT) Idxalloc_size_b() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_ROOT_Idxalloc_size_b+self.Offset)
}

func (self *INDEX_ROOT) Idx_size_c() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_INDEX_ROOT_Idx_size_c+self.Offset)
}

func (self *INDEX_ROOT) Node() *INDEX_NODE_HEADER {
	return self.Profile.INDEX_NODE_HEADER(self.Reader, self.Profile.Off_INDEX_ROOT_Node+self.Offset)
}
func (self *INDEX_ROOT) DebugString() string {
	result := fmt.Sprintf("struct INDEX_ROOT @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Type: %#0x\n", self.Type())
	result += fmt.Sprintf("  Collation_rule: %#0x\n", self.Collation_rule())
	result += fmt.Sprintf("  Idxalloc_size_b: %#0x\n", self.Idxalloc_size_b())
	result += fmt.Sprintf("  Idx_size_c: %#0x\n", self.Idx_size_c())
	result += fmt.Sprintf("  Node: {\n%v}\n", indent(self.Node().DebugString()))
	return result
}

type NTFS_BOOT_SECTOR struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *NTFS_BOOT_SECTOR) Size() int {
	return 512
}

func (self *NTFS_BOOT_SECTOR) Oemname() string {
	return ParseString(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR_Oemname+self.Offset, 8)
}

func (self *NTFS_BOOT_SECTOR) Sector_size() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR_Sector_size+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) _cluster_size() byte {
	return ParseUint8(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR__cluster_size+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) _volume_size() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR__volume_size+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) _mft_cluster() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR__mft_cluster+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) _mirror_mft_cluster() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR__mirror_mft_cluster+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) _mft_record_size() int8 {
	return ParseInt8(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR__mft_record_size+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) Index_record_size() byte {
	return ParseUint8(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR_Index_record_size+self.Offset)
}

func (self *NTFS_BOOT_SECTOR) Serial() string {
	return ParseString(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR_Serial+self.Offset, 8)
}

func (self *NTFS_BOOT_SECTOR) Magic() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_NTFS_BOOT_SECTOR_Magic+self.Offset)
}
func (self *NTFS_BOOT_SECTOR) DebugString() string {
	result := fmt.Sprintf("struct NTFS_BOOT_SECTOR @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Oemname: %v\n", string(self.Oemname()))
	result += fmt.Sprintf("  Sector_size: %#0x\n", self.Sector_size())
	result += fmt.Sprintf("  _cluster_size: %#0x\n", self._cluster_size())
	result += fmt.Sprintf("  _volume_size: %#0x\n", self._volume_size())
	result += fmt.Sprintf("  _mft_cluster: %#0x\n", self._mft_cluster())
	result += fmt.Sprintf("  _mirror_mft_cluster: %#0x\n", self._mirror_mft_cluster())
	result += fmt.Sprintf("  _mft_record_size: %#0x\n", self._mft_record_size())
	result += fmt.Sprintf("  Index_record_size: %#0x\n", self.Index_record_size())
	result += fmt.Sprintf("  Serial: %v\n", string(self.Serial()))
	result += fmt.Sprintf("  Magic: %#0x\n", self.Magic())
	return result
}

type NTFS_RESIDENT_ATTRIBUTE struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Size() int {
	return 0
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Type() *Enumeration {
	value := ParseUint32(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_Type+self.Offset)
	name := "Unknown"
	switch value {

	case 16:
		name = "$STANDARD_INFORMATION"

	case 32:
		name = "$ATTRIBUTE_LIST"

	case 48:
		name = "$FILE_NAME"

	case 64:
		name = "$OBJECT_ID"

	case 80:
		name = "$SECURITY_DESCRIPTOR"

	case 96:
		name = "$VOLUME_NAME"

	case 112:
		name = "$VOLUME_INFORMATION"

	case 128:
		name = "$DATA"

	case 144:
		name = "$INDEX_ROOT"

	case 160:
		name = "$INDEX_ALLOCATION"

	case 176:
		name = "$BITMAP"

	case 192:
		name = "$REPARSE_POINT"

	case 256:
		name = "$LOGGED_UTILITY_STREAM"
	}
	return &Enumeration{Value: uint64(value), Name: name}
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Length() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_Length+self.Offset)
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Resident() *Enumeration {
	value := ParseUint8(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_Resident+self.Offset)
	name := "Unknown"
	switch value {

	case 0:
		name = "RESIDENT"

	case 1:
		name = "NON-RESIDENT"
	}
	return &Enumeration{Value: uint64(value), Name: name}
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Name_length() byte {
	return ParseUint8(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_Name_length+self.Offset)
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Name_offset() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_Name_offset+self.Offset)
}

func (self *NTFS_RESIDENT_ATTRIBUTE) Attribute_id() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_Attribute_id+self.Offset)
}

func (self *NTFS_RESIDENT_ATTRIBUTE) content_size() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_content_size+self.Offset)
}

func (self *NTFS_RESIDENT_ATTRIBUTE) content_offset() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_NTFS_RESIDENT_ATTRIBUTE_content_offset+self.Offset)
}
func (self *NTFS_RESIDENT_ATTRIBUTE) DebugString() string {
	result := fmt.Sprintf("struct NTFS_RESIDENT_ATTRIBUTE @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Type: %v\n", self.Type().DebugString())
	result += fmt.Sprintf("  Length: %#0x\n", self.Length())
	result += fmt.Sprintf("  Resident: %v\n", self.Resident().DebugString())
	result += fmt.Sprintf("  Name_length: %#0x\n", self.Name_length())
	result += fmt.Sprintf("  Name_offset: %#0x\n", self.Name_offset())
	result += fmt.Sprintf("  Attribute_id: %#0x\n", self.Attribute_id())
	result += fmt.Sprintf("  content_size: %#0x\n", self.content_size())
	result += fmt.Sprintf("  content_offset: %#0x\n", self.content_offset())
	return result
}

type STANDARD_INDEX_HEADER struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *STANDARD_INDEX_HEADER) Size() int {
	return 42
}

func (self *STANDARD_INDEX_HEADER) MagicNumber() *Signature {
	value := ParseSignature(self.Reader, self.Profile.Off_STANDARD_INDEX_HEADER_MagicNumber+self.Offset, 4)
	return &Signature{value: value, signature: "INDX"}
}

func (self *STANDARD_INDEX_HEADER) Fixup_offset() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_STANDARD_INDEX_HEADER_Fixup_offset+self.Offset)
}

func (self *STANDARD_INDEX_HEADER) Fixup_count() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_STANDARD_INDEX_HEADER_Fixup_count+self.Offset)
}

func (self *STANDARD_INDEX_HEADER) LogFileSeqNum() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_STANDARD_INDEX_HEADER_LogFileSeqNum+self.Offset)
}

func (self *STANDARD_INDEX_HEADER) VcnOfINDX() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_STANDARD_INDEX_HEADER_VcnOfINDX+self.Offset)
}

func (self *STANDARD_INDEX_HEADER) Node() *INDEX_NODE_HEADER {
	return self.Profile.INDEX_NODE_HEADER(self.Reader, self.Profile.Off_STANDARD_INDEX_HEADER_Node+self.Offset)
}
func (self *STANDARD_INDEX_HEADER) DebugString() string {
	result := fmt.Sprintf("struct STANDARD_INDEX_HEADER @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Fixup_offset: %#0x\n", self.Fixup_offset())
	result += fmt.Sprintf("  Fixup_count: %#0x\n", self.Fixup_count())
	result += fmt.Sprintf("  LogFileSeqNum: %#0x\n", self.LogFileSeqNum())
	result += fmt.Sprintf("  VcnOfINDX: %#0x\n", self.VcnOfINDX())
	result += fmt.Sprintf("  Node: {\n%v}\n", indent(self.Node().DebugString()))
	return result
}

type STANDARD_INFORMATION struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *STANDARD_INFORMATION) Size() int {
	return 0
}

func (self *STANDARD_INFORMATION) Create_time() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Create_time+self.Offset)
}

func (self *STANDARD_INFORMATION) File_altered_time() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_STANDARD_INFORMATION_File_altered_time+self.Offset)
}

func (self *STANDARD_INFORMATION) Mft_altered_time() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Mft_altered_time+self.Offset)
}

func (self *STANDARD_INFORMATION) File_accessed_time() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_STANDARD_INFORMATION_File_accessed_time+self.Offset)
}

func (self *STANDARD_INFORMATION) Flags() *Flags {
	value := ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Flags+self.Offset)
	names := make(map[string]bool)

	if value&4096 != 0 {
		names["OFFLINE"] = true
	}

	if value&2 != 0 {
		names["HIDDEN"] = true
	}

	if value&32 != 0 {
		names["ARCHIVE"] = true
	}

	if value&64 != 0 {
		names["DEVICE"] = true
	}

	if value&128 != 0 {
		names["NORMAL"] = true
	}

	if value&256 != 0 {
		names["TEMPORARY"] = true
	}

	if value&1024 != 0 {
		names["REPARSE_POINT"] = true
	}

	if value&2048 != 0 {
		names["COMPRESSED"] = true
	}

	if value&8192 != 0 {
		names["NOT_INDEXED"] = true
	}

	if value&16384 != 0 {
		names["ENCRYPTED"] = true
	}

	if value&1 != 0 {
		names["READ_ONLY"] = true
	}

	if value&4 != 0 {
		names["SYSTEM"] = true
	}

	if value&512 != 0 {
		names["SPARSE"] = true
	}

	return &Flags{Value: uint64(value), Names: names}
}

func (self *STANDARD_INFORMATION) Max_versions() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Max_versions+self.Offset)
}

func (self *STANDARD_INFORMATION) Version() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Version+self.Offset)
}

func (self *STANDARD_INFORMATION) Class_id() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Class_id+self.Offset)
}

func (self *STANDARD_INFORMATION) Owner_id() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Owner_id+self.Offset)
}

func (self *STANDARD_INFORMATION) Sid() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Sid+self.Offset)
}

func (self *STANDARD_INFORMATION) Quota() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Quota+self.Offset)
}

func (self *STANDARD_INFORMATION) Usn() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_STANDARD_INFORMATION_Usn+self.Offset)
}
func (self *STANDARD_INFORMATION) DebugString() string {
	result := fmt.Sprintf("struct STANDARD_INFORMATION @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Create_time: {\n%v}\n", indent(self.Create_time().DebugString()))
	result += fmt.Sprintf("  File_altered_time: {\n%v}\n", indent(self.File_altered_time().DebugString()))
	result += fmt.Sprintf("  Mft_altered_time: {\n%v}\n", indent(self.Mft_altered_time().DebugString()))
	result += fmt.Sprintf("  File_accessed_time: {\n%v}\n", indent(self.File_accessed_time().DebugString()))
	result += fmt.Sprintf("  Flags: %v\n", self.Flags().DebugString())
	result += fmt.Sprintf("  Max_versions: %#0x\n", self.Max_versions())
	result += fmt.Sprintf("  Version: %#0x\n", self.Version())
	result += fmt.Sprintf("  Class_id: %#0x\n", self.Class_id())
	result += fmt.Sprintf("  Owner_id: %#0x\n", self.Owner_id())
	result += fmt.Sprintf("  Sid: %#0x\n", self.Sid())
	result += fmt.Sprintf("  Quota: %#0x\n", self.Quota())
	result += fmt.Sprintf("  Usn: %#0x\n", self.Usn())
	return result
}

type USN_RECORD_V2 struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *USN_RECORD_V2) Size() int {
	return 4
}

func (self *USN_RECORD_V2) RecordLength() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_USN_RECORD_V2_RecordLength+self.Offset)
}

func (self *USN_RECORD_V2) MajorVersion() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_USN_RECORD_V2_MajorVersion+self.Offset)
}

func (self *USN_RECORD_V2) MinorVersion() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_USN_RECORD_V2_MinorVersion+self.Offset)
}

func (self *USN_RECORD_V2) FileReferenceNumberSequence() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_USN_RECORD_V2_FileReferenceNumberSequence+self.Offset)
	return (uint64(value) & 0x7fffffffffffffff) >> 0x30
}

func (self *USN_RECORD_V2) FileReferenceNumberID() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_USN_RECORD_V2_FileReferenceNumberID+self.Offset)
	return (uint64(value) & 0xffffffffffff) >> 0x0
}

func (self *USN_RECORD_V2) ParentFileReferenceNumberSequence() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_USN_RECORD_V2_ParentFileReferenceNumberSequence+self.Offset)
	return (uint64(value) & 0x7fffffffffffffff) >> 0x30
}

func (self *USN_RECORD_V2) ParentFileReferenceNumberID() uint64 {
	value := ParseUint64(self.Reader, self.Profile.Off_USN_RECORD_V2_ParentFileReferenceNumberID+self.Offset)
	return (uint64(value) & 0xffffffffffff) >> 0x0
}

func (self *USN_RECORD_V2) Usn() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_USN_RECORD_V2_Usn+self.Offset)
}

func (self *USN_RECORD_V2) TimeStamp() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_USN_RECORD_V2_TimeStamp+self.Offset)
}

func (self *USN_RECORD_V2) Reason() *Flags {
	value := ParseUint32(self.Reader, self.Profile.Off_USN_RECORD_V2_Reason+self.Offset)
	names := make(map[string]bool)

	if value&(1<<1) != 0 {
		names["DATA_EXTEND"] = true
	}

	if value&(1<<10) != 0 {
		names["EA_CHANGE"] = true
	}

	if value&(1<<6) != 0 {
		names["NAMED_DATA_TRUNCATION"] = true
	}

	if value&(1<<8) != 0 {
		names["FILE_CREATE"] = true
	}

	if value&(1<<13) != 0 {
		names["RENAME_NEW_NAME"] = true
	}

	if value&(1<<17) != 0 {
		names["COMPRESSION_CHANGE"] = true
	}

	if value&(1<<2) != 0 {
		names["DATA_TRUNCATION"] = true
	}

	if value&(1<<4) != 0 {
		names["NAMED_DATA_OVERWRITE"] = true
	}

	if value&(1<<15) != 0 {
		names["BASIC_INFO_CHANGE"] = true
	}

	if value&(1<<20) != 0 {
		names["REPARSE_POINT_CHANGE"] = true
	}

	if value&(1<<31) != 0 {
		names["CLOSE"] = true
	}

	if value&(1<<5) != 0 {
		names["NAMED_DATA_EXTEND"] = true
	}

	if value&(1<<12) != 0 {
		names["RENAME_OLD_NAME"] = true
	}

	if value&(1<<11) != 0 {
		names["SECURITY_CHANGE"] = true
	}

	if value&(1<<14) != 0 {
		names["INDEXABLE_CHANGE"] = true
	}

	if value&(1<<16) != 0 {
		names["HARD_LINK_CHANGE"] = true
	}

	if value&(1<<18) != 0 {
		names["ENCRYPTION_CHANGE"] = true
	}

	if value&(1<<19) != 0 {
		names["OBJECT_ID_CHANGE"] = true
	}

	if value&(1<<21) != 0 {
		names["STREAM_CHANGE"] = true
	}

	if value&(1<<0) != 0 {
		names["DATA_OVERWRITE"] = true
	}

	if value&(1<<9) != 0 {
		names["FILE_DELETE"] = true
	}

	return &Flags{Value: uint64(value), Names: names}
}

func (self *USN_RECORD_V2) SourceInfo() *Flags {
	value := ParseUint32(self.Reader, self.Profile.Off_USN_RECORD_V2_SourceInfo+self.Offset)
	names := make(map[string]bool)

	if value&(1<<1) != 0 {
		names["AUXILIARY_DATA"] = true
	}

	if value&(1<<2) != 0 {
		names["REPLICATION_MANAGEMENT"] = true
	}

	if value&(1<<0) != 0 {
		names["DATA_MANAGEMENT"] = true
	}

	return &Flags{Value: uint64(value), Names: names}
}

func (self *USN_RECORD_V2) SecurityId() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_USN_RECORD_V2_SecurityId+self.Offset)
}

func (self *USN_RECORD_V2) FileAttributes() *Flags {
	value := ParseUint32(self.Reader, self.Profile.Off_USN_RECORD_V2_FileAttributes+self.Offset)
	names := make(map[string]bool)

	if value&(1<<7) != 0 {
		names["NORMAL"] = true
	}

	if value&(1<<13) != 0 {
		names["NOT_CONTENT_INDEXED"] = true
	}

	if value&(1<<15) != 0 {
		names["INTEGRITY_STREAM"] = true
	}

	if value&(1<<0) != 0 {
		names["READONLY"] = true
	}

	if value&(1<<2) != 0 {
		names["SYSTEM"] = true
	}

	if value&(1<<4) != 0 {
		names["DIRECTORY"] = true
	}

	if value&(1<<5) != 0 {
		names["ARCHIVE"] = true
	}

	if value&(1<<10) != 0 {
		names["REPARSE_POINT"] = true
	}

	if value&(1<<11) != 0 {
		names["COMPRESSED"] = true
	}

	if value&(1<<14) != 0 {
		names["ENCRYPTED"] = true
	}

	if value&(1<<12) != 0 {
		names["OFFLINE"] = true
	}

	if value&(1<<16) != 0 {
		names["VIRTUAL"] = true
	}

	if value&(1<<1) != 0 {
		names["HIDDEN"] = true
	}

	if value&(1<<6) != 0 {
		names["DEVICE"] = true
	}

	if value&(1<<8) != 0 {
		names["TEMPORARY"] = true
	}

	if value&(1<<9) != 0 {
		names["SPARSE_FILE"] = true
	}

	if value&(1<<17) != 0 {
		names["NO_SCRUB_DATA"] = true
	}

	return &Flags{Value: uint64(value), Names: names}
}

func (self *USN_RECORD_V2) FileNameLength() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_USN_RECORD_V2_FileNameLength+self.Offset)
}

func (self *USN_RECORD_V2) FileNameOffset() uint16 {
	return ParseUint16(self.Reader, self.Profile.Off_USN_RECORD_V2_FileNameOffset+self.Offset)
}
func (self *USN_RECORD_V2) DebugString() string {
	result := fmt.Sprintf("struct USN_RECORD_V2 @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  RecordLength: %#0x\n", self.RecordLength())
	result += fmt.Sprintf("  MajorVersion: %#0x\n", self.MajorVersion())
	result += fmt.Sprintf("  MinorVersion: %#0x\n", self.MinorVersion())
	result += fmt.Sprintf("  FileReferenceNumberSequence: %#0x\n", self.FileReferenceNumberSequence())
	result += fmt.Sprintf("  FileReferenceNumberID: %#0x\n", self.FileReferenceNumberID())
	result += fmt.Sprintf("  ParentFileReferenceNumberSequence: %#0x\n", self.ParentFileReferenceNumberSequence())
	result += fmt.Sprintf("  ParentFileReferenceNumberID: %#0x\n", self.ParentFileReferenceNumberID())
	result += fmt.Sprintf("  Usn: %#0x\n", self.Usn())
	result += fmt.Sprintf("  TimeStamp: {\n%v}\n", indent(self.TimeStamp().DebugString()))
	result += fmt.Sprintf("  Reason: %v\n", self.Reason().DebugString())
	result += fmt.Sprintf("  SourceInfo: %v\n", self.SourceInfo().DebugString())
	result += fmt.Sprintf("  SecurityId: %#0x\n", self.SecurityId())
	result += fmt.Sprintf("  FileAttributes: %v\n", self.FileAttributes().DebugString())
	result += fmt.Sprintf("  FileNameLength: %#0x\n", self.FileNameLength())
	result += fmt.Sprintf("  FileNameOffset: %#0x\n", self.FileNameOffset())
	return result
}

type VSS_CATALOG_ENTRY_1 struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_CATALOG_ENTRY_1) Size() int {
	return 128
}

func (self *VSS_CATALOG_ENTRY_1) EntryType() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_1_EntryType+self.Offset))
}
func (self *VSS_CATALOG_ENTRY_1) DebugString() string {
	result := fmt.Sprintf("struct VSS_CATALOG_ENTRY_1 @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  EntryType: %#0x\n", self.EntryType())
	return result
}

type VSS_CATALOG_ENTRY_2 struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_CATALOG_ENTRY_2) Size() int {
	return 128
}

func (self *VSS_CATALOG_ENTRY_2) EntryType() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_2_EntryType+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_2) VolumeSize() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_2_VolumeSize+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_2) StoreGUID() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_2_StoreGUID+self.Offset)
}

func (self *VSS_CATALOG_ENTRY_2) CreationTime() *WinFileTime {
	return self.Profile.WinFileTime(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_2_CreationTime+self.Offset)
}
func (self *VSS_CATALOG_ENTRY_2) DebugString() string {
	result := fmt.Sprintf("struct VSS_CATALOG_ENTRY_2 @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  EntryType: %#0x\n", self.EntryType())
	result += fmt.Sprintf("  VolumeSize: %#0x\n", self.VolumeSize())
	result += fmt.Sprintf("  StoreGUID: {\n%v}\n", indent(self.StoreGUID().DebugString()))
	result += fmt.Sprintf("  CreationTime: {\n%v}\n", indent(self.CreationTime().DebugString()))
	return result
}

type VSS_CATALOG_ENTRY_3 struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_CATALOG_ENTRY_3) Size() int {
	return 128
}

func (self *VSS_CATALOG_ENTRY_3) EntryType() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_EntryType+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) StoreBlockListOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_StoreBlockListOffset+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) StoreGUID() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_StoreGUID+self.Offset)
}

func (self *VSS_CATALOG_ENTRY_3) StoreHeaderOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_StoreHeaderOffset+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) StoreBlockRangeListOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_StoreBlockRangeListOffset+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) StoreBitmapOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_StoreBitmapOffset+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) NTFSFileReference() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_NTFSFileReference+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) AllocatedSize() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_AllocatedSize+self.Offset))
}

func (self *VSS_CATALOG_ENTRY_3) StorePreviousBitmapOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_ENTRY_3_StorePreviousBitmapOffset+self.Offset))
}
func (self *VSS_CATALOG_ENTRY_3) DebugString() string {
	result := fmt.Sprintf("struct VSS_CATALOG_ENTRY_3 @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  EntryType: %#0x\n", self.EntryType())
	result += fmt.Sprintf("  StoreBlockListOffset: %#0x\n", self.StoreBlockListOffset())
	result += fmt.Sprintf("  StoreGUID: {\n%v}\n", indent(self.StoreGUID().DebugString()))
	result += fmt.Sprintf("  StoreHeaderOffset: %#0x\n", self.StoreHeaderOffset())
	result += fmt.Sprintf("  StoreBlockRangeListOffset: %#0x\n", self.StoreBlockRangeListOffset())
	result += fmt.Sprintf("  StoreBitmapOffset: %#0x\n", self.StoreBitmapOffset())
	result += fmt.Sprintf("  NTFSFileReference: %#0x\n", self.NTFSFileReference())
	result += fmt.Sprintf("  AllocatedSize: %#0x\n", self.AllocatedSize())
	result += fmt.Sprintf("  StorePreviousBitmapOffset: %#0x\n", self.StorePreviousBitmapOffset())
	return result
}

type VSS_CATALOG_HEADER struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_CATALOG_HEADER) Size() int {
	return 128
}

func (self *VSS_CATALOG_HEADER) Identifier() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_CATALOG_HEADER_Identifier+self.Offset)
}

func (self *VSS_CATALOG_HEADER) Version() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_VSS_CATALOG_HEADER_Version+self.Offset)
}

func (self *VSS_CATALOG_HEADER) RecordType() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_VSS_CATALOG_HEADER_RecordType+self.Offset)
}

func (self *VSS_CATALOG_HEADER) RelativeOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_HEADER_RelativeOffset+self.Offset))
}

func (self *VSS_CATALOG_HEADER) CurrentOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_HEADER_CurrentOffset+self.Offset))
}

func (self *VSS_CATALOG_HEADER) NextOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_CATALOG_HEADER_NextOffset+self.Offset))
}
func (self *VSS_CATALOG_HEADER) DebugString() string {
	result := fmt.Sprintf("struct VSS_CATALOG_HEADER @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Identifier: {\n%v}\n", indent(self.Identifier().DebugString()))
	result += fmt.Sprintf("  Version: %#0x\n", self.Version())
	result += fmt.Sprintf("  RecordType: %#0x\n", self.RecordType())
	result += fmt.Sprintf("  RelativeOffset: %#0x\n", self.RelativeOffset())
	result += fmt.Sprintf("  CurrentOffset: %#0x\n", self.CurrentOffset())
	result += fmt.Sprintf("  NextOffset: %#0x\n", self.NextOffset())
	return result
}

type VSS_STORE_BLOCK_HEADER struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_STORE_BLOCK_HEADER) Size() int {
	return 128
}

func (self *VSS_STORE_BLOCK_HEADER) Identifier() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_Identifier+self.Offset)
}

func (self *VSS_STORE_BLOCK_HEADER) Version() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_Version+self.Offset)
}

func (self *VSS_STORE_BLOCK_HEADER) RecordType() *Enumeration {
	value := ParseUint32(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_RecordType+self.Offset)
	name := "Unknown"
	switch value {

	case 1:
		name = "VolumeHeader"

	case 2:
		name = "CatalogBlockHeader"

	case 3:
		name = "BlockDescriptorList"

	case 4:
		name = "StoreHeader"

	case 5:
		name = "StoreBlockRangesList"

	case 6:
		name = "StoreBitmap"
	}
	return &Enumeration{Value: uint64(value), Name: name}
}

func (self *VSS_STORE_BLOCK_HEADER) RelativeOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_RelativeOffset+self.Offset))
}

func (self *VSS_STORE_BLOCK_HEADER) CurrentOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_CurrentOffset+self.Offset))
}

func (self *VSS_STORE_BLOCK_HEADER) NextOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_NextOffset+self.Offset))
}

func (self *VSS_STORE_BLOCK_HEADER) SizeOfStore() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_STORE_BLOCK_HEADER_SizeOfStore+self.Offset))
}
func (self *VSS_STORE_BLOCK_HEADER) DebugString() string {
	result := fmt.Sprintf("struct VSS_STORE_BLOCK_HEADER @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Identifier: {\n%v}\n", indent(self.Identifier().DebugString()))
	result += fmt.Sprintf("  Version: %#0x\n", self.Version())
	result += fmt.Sprintf("  RecordType: %v\n", self.RecordType().DebugString())
	result += fmt.Sprintf("  RelativeOffset: %#0x\n", self.RelativeOffset())
	result += fmt.Sprintf("  CurrentOffset: %#0x\n", self.CurrentOffset())
	result += fmt.Sprintf("  NextOffset: %#0x\n", self.NextOffset())
	result += fmt.Sprintf("  SizeOfStore: %#0x\n", self.SizeOfStore())
	return result
}

type VSS_STORE_INFORMATION struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_STORE_INFORMATION) Size() int {
	return 0
}

func (self *VSS_STORE_INFORMATION) ShadowCopyGUID() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_STORE_INFORMATION_ShadowCopyGUID+self.Offset)
}

func (self *VSS_STORE_INFORMATION) ShadowCopySetGUID() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_STORE_INFORMATION_ShadowCopySetGUID+self.Offset)
}

func (self *VSS_STORE_INFORMATION) SnapshotContext() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_VSS_STORE_INFORMATION_SnapshotContext+self.Offset)
}

func (self *VSS_STORE_INFORMATION) AttributeFlags() *Flags {
	value := ParseUint32(self.Reader, self.Profile.Off_VSS_STORE_INFORMATION_AttributeFlags+self.Offset)
	names := make(map[string]bool)

	if value&8388608 != 0 {
		names["VSS_VOLSNAP_ATTR_ROLLBACK_RECOVERY"] = true
	}

	if value&2 != 0 {
		names["VSS_VOLSNAP_ATTR_NO_AUTORECOVERY"] = true
	}

	if value&4 != 0 {
		names["VSS_VOLSNAP_ATTR_CLIENT_ACCESSIBLE"] = true
	}

	if value&16 != 0 {
		names["VSS_VOLSNAP_ATTR_NO_WRITERS"] = true
	}

	if value&64 != 0 {
		names["VSS_VOLSNAP_ATTR_NOT_SURFACED"] = true
	}

	if value&128 != 0 {
		names["VSS_VOLSNAP_ATTR_NOT_TRANSACTED"] = true
	}

	if value&131072 != 0 {
		names["VSS_VOLSNAP_ATTR_DIFFERENTIAL"] = true
	}

	if value&262144 != 0 {
		names["VSS_VOLSNAP_ATTR_PLEX"] = true
	}

	if value&1 != 0 {
		names["VSS_VOLSNAP_ATTR_PERSISTENT"] = true
	}

	if value&32 != 0 {
		names["VSS_VOLSNAP_ATTR_TRANSPORTABLE"] = true
	}

	if value&2097152 != 0 {
		names["VSS_VOLSNAP_ATTR_EXPOSED_REMOTELY"] = true
	}

	if value&4194304 != 0 {
		names["VSS_VOLSNAP_ATTR_AUTORECOVER"] = true
	}

	if value&16777216 != 0 {
		names["VSS_VOLSNAP_ATTR_DELAYED_POSTSNAPSHOT"] = true
	}

	if value&33554432 != 0 {
		names["VSS_VOLSNAP_ATTR_TXF_RECOVERY"] = true
	}

	if value&8 != 0 {
		names["VSS_VOLSNAP_ATTR_NO_AUTO_RELEASE"] = true
	}

	if value&65536 != 0 {
		names["VSS_VOLSNAP_ATTR_HARDWARE_ASSISTED"] = true
	}

	if value&524288 != 0 {
		names["VSS_VOLSNAP_ATTR_IMPORTED"] = true
	}

	if value&1048576 != 0 {
		names["VSS_VOLSNAP_ATTR_EXPOSED_LOCALLY"] = true
	}

	return &Flags{Value: uint64(value), Names: names}
}

func (self *VSS_STORE_INFORMATION) DebugString() string {
	result := fmt.Sprintf("struct VSS_STORE_INFORMATION @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  ShadowCopyGUID: {\n%v}\n", indent(self.ShadowCopyGUID().DebugString()))
	result += fmt.Sprintf("  ShadowCopySetGUID: {\n%v}\n", indent(self.ShadowCopySetGUID().DebugString()))
	result += fmt.Sprintf("  SnapshotContext: %#0x\n", self.SnapshotContext())
	result += fmt.Sprintf("  AttributeFlags: %v\n", self.AttributeFlags().DebugString())
	return result
}

type VSS_VOLUME_HEADER struct {
	Reader  io.ReaderAt
	Offset  int64
	Profile *NTFSProfile
}

func (self *VSS_VOLUME_HEADER) Size() int {
	return 0
}

func (self *VSS_VOLUME_HEADER) Identifier() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_Identifier+self.Offset)
}

func (self *VSS_VOLUME_HEADER) Version() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_Version+self.Offset)
}

func (self *VSS_VOLUME_HEADER) RecordType() uint32 {
	return ParseUint32(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_RecordType+self.Offset)
}

func (self *VSS_VOLUME_HEADER) CurrentOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_CurrentOffset+self.Offset))
}

func (self *VSS_VOLUME_HEADER) CatalogOffset() int64 {
	return int64(ParseUint64(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_CatalogOffset+self.Offset))
}

func (self *VSS_VOLUME_HEADER) MaxSize() uint64 {
	return ParseUint64(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_MaxSize+self.Offset)
}

func (self *VSS_VOLUME_HEADER) VolumeGUID() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_VolumeGUID+self.Offset)
}

func (self *VSS_VOLUME_HEADER) ShadowVolumeGUID() *GUID {
	return self.Profile.GUID(self.Reader, self.Profile.Off_VSS_VOLUME_HEADER_ShadowVolumeGUID+self.Offset)
}
func (self *VSS_VOLUME_HEADER) DebugString() string {
	result := fmt.Sprintf("struct VSS_VOLUME_HEADER @ %#x:\n", self.Offset)
	result += fmt.Sprintf("  Identifier: {\n%v}\n", indent(self.Identifier().DebugString()))
	result += fmt.Sprintf("  Version: %#0x\n", self.Version())
	result += fmt.Sprintf("  RecordType: %#0x\n", self.RecordType())
	result += fmt.Sprintf("  CurrentOffset: %#0x\n", self.CurrentOffset())
	result += fmt.Sprintf("  CatalogOffset: %#0x\n", self.CatalogOffset())
	result += fmt.Sprintf("  MaxSize: %#0x\n", self.MaxSize())
	result += fmt.Sprintf("  VolumeGUID: {\n%v}\n", indent(self.VolumeGUID().DebugString()))
	result += fmt.Sprintf("  ShadowVolumeGUID: {\n%v}\n", indent(self.ShadowVolumeGUID().DebugString()))
	return result
}

type Enumeration struct {
	Value uint64
	Name  string
}

func (self Enumeration) DebugString() string {
	return fmt.Sprintf("%s (%d)", self.Name, self.Value)
}

type Flags struct {
	Value uint64
	Names map[string]bool
}

func (self Flags) DebugString() string {
	names := []string{}
	for k, _ := range self.Names {
		names = append(names, k)
	}

	sort.Strings(names)

	return fmt.Sprintf("%d (%s)", self.Value, strings.Join(names, ","))
}

func (self Flags) IsSet(flag string) bool {
	result, _ := self.Names[flag]
	return result
}

func (self Flags) Values() []string {
	result := make([]string, 0, len(self.Names))
	for k, _ := range self.Names {
		result = append(result, k)
	}
	return result
}

func ParseArray_byte(profile *NTFSProfile, reader io.ReaderAt, offset int64, count int) []byte {
	result := []byte{}
	for i := 0; i < count; i++ {
		value := ParseUint8(reader, offset)
		result = append(result, value)
		offset += int64(1)
	}
	return result
}

func ParseInt32(reader io.ReaderAt, offset int64) int32 {
	data := make([]byte, 4)
	_, err := reader.ReadAt(data, offset)
	if err != nil {
		return 0
	}
	return int32(binary.LittleEndian.Uint32(data))
}

func ParseInt64(reader io.ReaderAt, offset int64) int64 {
	data := make([]byte, 8)
	_, err := reader.ReadAt(data, offset)
	if err != nil {
		return 0
	}
	return int64(binary.LittleEndian.Uint64(data))
}

func ParseInt8(reader io.ReaderAt, offset int64) int8 {
	result := make([]byte, 1)
	_, err := reader.ReadAt(result, offset)
	if err != nil {
		return 0
	}
	return int8(result[0])
}

func ParseUint16(reader io.ReaderAt, offset int64) uint16 {
	data := make([]byte, 2)
	_, err := reader.ReadAt(data, offset)
	if err != nil {
		return 0
	}
	return binary.LittleEndian.Uint16(data)
}

func ParseUint32(reader io.ReaderAt, offset int64) uint32 {
	data := make([]byte, 4)
	_, err := reader.ReadAt(data, offset)
	if err != nil {
		return 0
	}
	return binary.LittleEndian.Uint32(data)
}

func ParseUint64(reader io.ReaderAt, offset int64) uint64 {
	data := make([]byte, 8)
	_, err := reader.ReadAt(data, offset)
	if err != nil {
		return 0
	}
	return binary.LittleEndian.Uint64(data)
}

func ParseUint8(reader io.ReaderAt, offset int64) byte {
	result := make([]byte, 1)
	_, err := reader.ReadAt(result, offset)
	if err != nil {
		return 0
	}
	return result[0]
}

type Signature struct {
	value, signature string
}

func (self Signature) IsValid() bool {
	return self.value == self.signature
}

func ParseSignature(reader io.ReaderAt, offset int64, length int64) string {
	data := make([]byte, length)
	n, err := reader.ReadAt(data, offset)
	if err != nil && err != io.EOF {
		return ""
	}
	return string(data[:n])
}

func ParseTerminatedString(reader io.ReaderAt, offset int64) string {
	data := make([]byte, 1024)
	n, err := reader.ReadAt(data, offset)
	if err != nil && err != io.EOF {
		return ""
	}
	idx := bytes.Index(data[:n], []byte{0})
	if idx < 0 {
		idx = n
	}
	return string(data[0:idx])
}

func ParseString(reader io.ReaderAt, offset int64, length int64) string {
	data := make([]byte, length)
	n, err := reader.ReadAt(data, offset)
	if err != nil && err != io.EOF {
		return ""
	}
	return string(data[:n])
}

func ParseTerminatedUTF16String(reader io.ReaderAt, offset int64) string {
	data := make([]byte, 1024)
	n, err := reader.ReadAt(data, offset)
	if err != nil && err != io.EOF {
		return ""
	}

	idx := bytes.Index(data[:n], []byte{0, 0})
	if idx < 0 {
		idx = n - 1
	}
	return UTF16BytesToUTF8(data[0:idx+1], binary.LittleEndian)
}

func ParseUTF16String(reader io.ReaderAt, offset int64, length int64) string {
	data := make([]byte, length)
	n, err := reader.ReadAt(data, offset)
	if err != nil && err != io.EOF {
		return ""
	}
	return UTF16BytesToUTF8(data[:n], binary.LittleEndian)
}

func UTF16BytesToUTF8(b []byte, o binary.ByteOrder) string {
	if len(b) < 2 {
		return ""
	}

	if b[0] == 0xff && b[1] == 0xfe {
		o = binary.BigEndian
		b = b[2:]
	} else if b[0] == 0xfe && b[1] == 0xff {
		o = binary.LittleEndian
		b = b[2:]
	}

	utf := make([]uint16, (len(b)+(2-1))/2)

	for i := 0; i+(2-1) < len(b); i += 2 {
		utf[i/2] = o.Uint16(b[i:])
	}
	if len(b)/2 < len(utf) {
		utf[len(utf)-1] = utf8.RuneError
	}

	return string(utf16.Decode(utf))
}
