// This file was autogenerated using go run mkcode.go -- token.go
// DO NOT EDIT.

package ntdll

import "unsafe"

// The TokenTypeT constants have been derived from the TOKEN_TYPE enum definition.
type TokenTypeT uint32

const (
	TokenPrimary       TokenTypeT = 1
	TokenImpersonation            = 2
)

// The TokenInformationClassT constants have been derived from the TOKEN_INFORMATION_CLASS enum definition.
type TokenInformationClassT uint32

const (
	TokenUser                            TokenInformationClassT = 1
	TokenGroups                                                 = 2
	TokenPrivileges                                             = 3
	TokenOwner                                                  = 4
	TokenPrimaryGroup                                           = 5
	TokenDefaultDacl                                            = 6
	TokenSource                                                 = 7
	TokenType                                                   = 8
	TokenImpersonationLevel                                     = 9
	TokenStatistics                                             = 10
	TokenRestrictedSids                                         = 11
	TokenSessionId                                              = 12
	TokenGroupsAndPrivileges                                    = 13
	TokenSessionReference                                       = 14
	TokenSandBoxInert                                           = 15
	TokenAuditPolicy                                            = 16
	TokenOrigin                                                 = 17
	TokenElevationType                                          = 18
	TokenLinkedToken                                            = 19
	TokenElevation                                              = 20
	TokenHasRestrictions                                        = 21
	TokenAccessInformation                                      = 22
	TokenVirtualizationAllowed                                  = 23
	TokenVirtualizationEnabled                                  = 24
	TokenIntegrityLevel                                         = 25
	TokenUIAccess                                               = 26
	TokenMandatoryPolicy                                        = 27
	TokenLogonSid                                               = 28
	TokenIsAppContainer                                         = 29
	TokenCapabilities                                           = 30
	TokenAppContainerSid                                        = 31
	TokenAppContainerNumber                                     = 32
	TokenUserClaimAttributes                                    = 33
	TokenDeviceClaimAttributes                                  = 34
	TokenRestrictedUserClaimAttributes                          = 35
	TokenRestrictedDeviceClaimAttributes                        = 36
	TokenDeviceGroups                                           = 37
	TokenRestrictedDeviceGroups                                 = 38
	TokenSecurityAttributes                                     = 39
	TokenIsRestricted                                           = 40
	TokenProcessTrustLevel                                      = 41
	TokenPrivateNameSpace                                       = 42
	TokenSingletonAttributes                                    = 43
	MaxTokenInfoClass                                           = 44
)

// The SecurityImpersonationLevel constants have been derived from the SECURITY_IMPERSONATION_LEVEL enum definition.
type SecurityImpersonationLevel uint32

const (
	SecurityAnonymous      SecurityImpersonationLevel = 0
	SecurityIdentification                            = 1
	SecurityImpersonation                             = 2
	SecurityDelegation                                = 3
)

var (
	procNtOpenThreadToken           = modntdll.NewProc("NtOpenThreadToken")
	procNtOpenThreadTokenEx         = modntdll.NewProc("NtOpenThreadTokenEx")
	procNtOpenProcessToken          = modntdll.NewProc("NtOpenProcessToken")
	procNtOpenProcessTokenEx        = modntdll.NewProc("NtOpenProcessTokenEx")
	procNtOpenJobObjectToken        = modntdll.NewProc("NtOpenJobObjectToken")
	procNtDuplicateToken            = modntdll.NewProc("NtDuplicateToken")
	procNtFilterToken               = modntdll.NewProc("NtFilterToken")
	procNtImpersonateAnonymousToken = modntdll.NewProc("NtImpersonateAnonymousToken")
	procNtQueryInformationToken     = modntdll.NewProc("NtQueryInformationToken")
	procNtSetInformationToken       = modntdll.NewProc("NtSetInformationToken")
	procNtAdjustPrivilegesToken     = modntdll.NewProc("NtAdjustPrivilegesToken")
	procNtAdjustGroupsToken         = modntdll.NewProc("NtAdjustGroupsToken")
)

// TokenUserT has been derived from the TOKEN_USER struct definition.
type TokenUserT struct {
	User SidAndAttributes
}

// TokenGroupsT has been derived from the TOKEN_GROUPS struct definition.
type TokenGroupsT struct {
	GroupCount uint32
	Groups     [1]SidAndAttributes
}

// TokenPrivilegesT has been derived from the TOKEN_PRIVILEGES struct definition.
type TokenPrivilegesT struct {
	PrivilegeCount uint32
	Privileges     [1]LuidAndAttributes
}

// TokenOwnerT has been derived from the TOKEN_OWNER struct definition.
type TokenOwnerT struct {
	Owner *Sid
}

// TokenPrimaryGroupT has been derived from the TOKEN_PRIMARY_GROUP struct definition.
type TokenPrimaryGroupT struct {
	PrimaryGroup *Sid
}

// TokenDefaultDaclT has been derived from the TOKEN_DEFAULT_DACL struct definition.
type TokenDefaultDaclT struct {
	DefaultDacl *Acl
}

// TokenUserClaimsT has been derived from the TOKEN_USER_CLAIMS struct definition.
type TokenUserClaimsT struct {
	UserClaims *ClaimsBlob
}

// TokenDeviceClaimsT has been derived from the TOKEN_DEVICE_CLAIMS struct definition.
type TokenDeviceClaimsT struct {
	DeviceClaims *ClaimsBlob
}

// TokenGroupsAndPrivilegesT has been derived from the TOKEN_GROUPS_AND_PRIVILEGES struct definition.
type TokenGroupsAndPrivilegesT struct {
	SidCount            uint32
	SidLength           uint32
	Sids                *SidAndAttributes
	RestrictedSidCount  uint32
	RestrictedSidLength uint32
	RestrictedSids      *SidAndAttributes
	PrivilegeCount      uint32
	PrivilegeLength     uint32
	Privileges          *LuidAndAttributes
	AuthenticationId    Luid
}

// TokenLinkedTokenT has been derived from the TOKEN_LINKED_TOKEN struct definition.
type TokenLinkedTokenT struct {
	LinkedToken Handle
}

// TokenElevationT has been derived from the TOKEN_ELEVATION struct definition.
type TokenElevationT struct {
	TokenIsElevated uint32
}

// TokenMandatoryLabelT has been derived from the TOKEN_MANDATORY_LABEL struct definition.
type TokenMandatoryLabelT struct {
	Label SidAndAttributes
}

// TokenMandatoryPolicyT has been derived from the TOKEN_MANDATORY_POLICY struct definition.
type TokenMandatoryPolicyT struct {
	Policy uint32
}

// TokenAccessInformationT has been derived from the TOKEN_ACCESS_INFORMATION struct definition.
type TokenAccessInformationT struct {
	SidHash            *SidAndAttributesHash
	RestrictedSidHash  *SidAndAttributesHash
	Privileges         *TokenPrivilegesT
	AuthenticationId   Luid
	TokenType          TokenTypeT
	ImpersonationLevel SecurityImpersonationLevel
	MandatoryPolicy    TokenMandatoryPolicyT
	Flags              uint32
	AppContainerNumber uint32
	PackageSid         *Sid
	CapabilitiesHash   *SidAndAttributesHash
	TrustLevelSid      *Sid
	SecurityAttributes *SecurityAttributesOpaque
}

// TokenAuditPolicyT has been derived from the TOKEN_AUDIT_POLICY struct definition.
type TokenAuditPolicyT struct {
	PerUserPolicy [30]byte
}

// TokenSourceT has been derived from the TOKEN_SOURCE struct definition.
type TokenSourceT struct {
	SourceName       [8]byte
	SourceIdentifier Luid
}

// TokenStatisticsT has been derived from the TOKEN_STATISTICS struct definition.
type TokenStatisticsT struct {
	TokenId            Luid
	AuthenticationId   Luid
	ExpirationTime     int64
	TokenType          TokenTypeT
	ImpersonationLevel SecurityImpersonationLevel
	DynamicCharged     uint32
	DynamicAvailable   uint32
	GroupCount         uint32
	PrivilegeCount     uint32
	ModifiedId         Luid
}

// TokenControlT has been derived from the TOKEN_CONTROL struct definition.
type TokenControlT struct {
	TokenId          Luid
	AuthenticationId Luid
	ModifiedId       Luid
	TokenSource      TokenSourceT
}

// TokenOriginT has been derived from the TOKEN_ORIGIN struct definition.
type TokenOriginT struct {
	OriginatingLogonSession Luid
}

// TokenAppcontainerInformationT has been derived from the TOKEN_APPCONTAINER_INFORMATION struct definition.
type TokenAppcontainerInformationT struct {
	TokenAppContainer *Sid
}

// TokenSidInformationT has been derived from the TOKEN_SID_INFORMATION struct definition.
type TokenSidInformationT struct {
	Sid *Sid
}

// Luid has been derived from the LUID struct definition.
type Luid struct {
	LowPart  uint32
	HighPart int32
}

// LuidAndAttributes has been derived from the LUID_AND_ATTRIBUTES struct definition.
type LuidAndAttributes struct {
	Luid       Luid
	Attributes uint32
}

// SidAndAttributes has been derived from the SID_AND_ATTRIBUTES struct definition.
type SidAndAttributes struct {
	Sid        *Sid
	Attributes uint32
}

// SidAndAttributesHash has been derived from the SID_AND_ATTRIBUTES_HASH struct definition.
type SidAndAttributesHash struct {
	SidCount uint32
	SidAttr  *SidAndAttributes
	Hash     [32]SidHashEntry
}

// OUT-parameter: TokenHandle.
func NtOpenThreadToken(
	ThreadHandle Handle,
	DesiredAccess AccessMask,
	OpenAsSelf bool,
	TokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtOpenThreadToken.Call(uintptr(ThreadHandle),
		uintptr(DesiredAccess),
		fromBool(OpenAsSelf),
		uintptr(unsafe.Pointer(TokenHandle)))
	return NtStatus(r0)
}

// OUT-parameter: TokenHandle.
func NtOpenThreadTokenEx(
	ThreadHandle Handle,
	DesiredAccess AccessMask,
	OpenAsSelf bool,
	HandleAttributes uint32,
	TokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtOpenThreadTokenEx.Call(uintptr(ThreadHandle),
		uintptr(DesiredAccess),
		fromBool(OpenAsSelf),
		uintptr(HandleAttributes),
		uintptr(unsafe.Pointer(TokenHandle)))
	return NtStatus(r0)
}

// OUT-parameter: TokenHandle.
func NtOpenProcessToken(
	ProcessHandle Handle,
	DesiredAccess AccessMask,
	TokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtOpenProcessToken.Call(uintptr(ProcessHandle),
		uintptr(DesiredAccess),
		uintptr(unsafe.Pointer(TokenHandle)))
	return NtStatus(r0)
}

// OUT-parameter: TokenHandle.
func NtOpenProcessTokenEx(
	ProcessHandle Handle,
	DesiredAccess AccessMask,
	HandleAttributes uint32,
	TokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtOpenProcessTokenEx.Call(uintptr(ProcessHandle),
		uintptr(DesiredAccess),
		uintptr(HandleAttributes),
		uintptr(unsafe.Pointer(TokenHandle)))
	return NtStatus(r0)
}

// OUT-parameter: TokenHandle.
func NtOpenJobObjectToken(
	JobHandle Handle,
	DesiredAccess AccessMask,
	TokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtOpenJobObjectToken.Call(uintptr(JobHandle),
		uintptr(DesiredAccess),
		uintptr(unsafe.Pointer(TokenHandle)))
	return NtStatus(r0)
}

// OUT-parameter: NewTokenHandle.
// *OPT-parameter: ObjectAttributes.
func NtDuplicateToken(
	ExistingTokenHandle Handle,
	DesiredAccess AccessMask,
	ObjectAttributes *ObjectAttributes,
	EffectiveOnly bool,
	TokenType TokenTypeT,
	NewTokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtDuplicateToken.Call(uintptr(ExistingTokenHandle),
		uintptr(DesiredAccess),
		uintptr(unsafe.Pointer(ObjectAttributes)),
		fromBool(EffectiveOnly),
		uintptr(TokenType),
		uintptr(unsafe.Pointer(NewTokenHandle)))
	return NtStatus(r0)
}

// OUT-parameter: NewTokenHandle.
// *OPT-parameter: SidsToDisable, PrivilegesToDelete, RestrictedSids.
func NtFilterToken(
	ExistingTokenHandle Handle,
	Flags uint32,
	SidsToDisable *TokenGroupsT,
	PrivilegesToDelete *TokenPrivilegesT,
	RestrictedSids *TokenGroupsT,
	NewTokenHandle *Handle,
) NtStatus {
	r0, _, _ := procNtFilterToken.Call(uintptr(ExistingTokenHandle),
		uintptr(Flags),
		uintptr(unsafe.Pointer(SidsToDisable)),
		uintptr(unsafe.Pointer(PrivilegesToDelete)),
		uintptr(unsafe.Pointer(RestrictedSids)),
		uintptr(unsafe.Pointer(NewTokenHandle)))
	return NtStatus(r0)
}

func NtImpersonateAnonymousToken(
	ThreadHandle Handle,
) NtStatus {
	r0, _, _ := procNtImpersonateAnonymousToken.Call(uintptr(ThreadHandle))
	return NtStatus(r0)
}

// OUT-parameter: TokenInformation, ReturnLength.
func NtQueryInformationToken(
	TokenHandle Handle,
	TokenInformationClass TokenInformationClassT,
	TokenInformation *byte,
	TokenInformationLength uint32,
	ReturnLength *uint32,
) NtStatus {
	r0, _, _ := procNtQueryInformationToken.Call(uintptr(TokenHandle),
		uintptr(TokenInformationClass),
		uintptr(unsafe.Pointer(TokenInformation)),
		uintptr(TokenInformationLength),
		uintptr(unsafe.Pointer(ReturnLength)))
	return NtStatus(r0)
}

func NtSetInformationToken(
	TokenHandle Handle,
	TokenInformationClass TokenInformationClassT,
	TokenInformation *byte,
	TokenInformationLength uint32,
) NtStatus {
	r0, _, _ := procNtSetInformationToken.Call(uintptr(TokenHandle),
		uintptr(TokenInformationClass),
		uintptr(unsafe.Pointer(TokenInformation)),
		uintptr(TokenInformationLength))
	return NtStatus(r0)
}

// OUT-parameter: PreviousState, ReturnLength.
// *OPT-parameter: NewState.
func NtAdjustPrivilegesToken(
	TokenHandle Handle,
	DisableAllPrivileges bool,
	NewState *TokenPrivilegesT,
	BufferLength uint32,
	PreviousState *TokenPrivilegesT,
	ReturnLength *uint32,
) NtStatus {
	r0, _, _ := procNtAdjustPrivilegesToken.Call(uintptr(TokenHandle),
		fromBool(DisableAllPrivileges),
		uintptr(unsafe.Pointer(NewState)),
		uintptr(BufferLength),
		uintptr(unsafe.Pointer(PreviousState)),
		uintptr(unsafe.Pointer(ReturnLength)))
	return NtStatus(r0)
}

// OUT-parameter: PreviousState, ReturnLength.
// *OPT-parameter: NewState, BufferLength.
func NtAdjustGroupsToken(
	TokenHandle Handle,
	ResetToDefault bool,
	NewState *TokenGroupsT,
	BufferLength uint32,
	PreviousState *TokenGroupsT,
	ReturnLength *uint32,
) NtStatus {
	r0, _, _ := procNtAdjustGroupsToken.Call(uintptr(TokenHandle),
		fromBool(ResetToDefault),
		uintptr(unsafe.Pointer(NewState)),
		uintptr(BufferLength),
		uintptr(unsafe.Pointer(PreviousState)),
		uintptr(unsafe.Pointer(ReturnLength)))
	return NtStatus(r0)
}
