/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.scm;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Property;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.util.Platform;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class AntStarTeamCheckOut
extends Task {
    public static final String DEFAULT_FORCESETTING = "false";
    public static final String DEFAULT_VERBOSESETTING = "false";
    public static final String DEFAULT_RECURSIONSETTING = "true";
    public static final String DEFAULT_INCLUDESETTING = "*";
    public static final String DEFAULT_EXCLUDESETTING = null;
    public static final String DEFAULT_FOLDERSETTING = null;
    private Folder prevFolder = null;
    private int checkedOut;
    private String serverName = null;
    private String serverPort = null;
    private String projectName = null;
    private String folderName = null;
    private String viewName = null;
    private String username = null;
    private String password = null;
    private String targetFolder = null;
    private String force = "false";
    private String verbose = "false";
    private String recursion = "true";
    private String includes = "*";
    private String excludes = null;
    private String delim = Platform.getFilePathDelim();

    public void execute() throws BuildException {
        File file;
        if (this.getServerName() == null) {
            this.project.log("ServerName must not be null.");
            return;
        }
        if (this.getServerPort() == null) {
            this.project.log("ServerPort must not be null.");
            return;
        }
        if (this.getProjectName() == null) {
            this.project.log("ProjectName must not be null.");
            return;
        }
        if (this.getViewName() == null) {
            this.project.log("ViewName must not be null.");
            return;
        }
        if (this.getUsername() == null) {
            this.project.log("Username must not be null.");
            return;
        }
        if (this.getPassword() == null) {
            this.project.log("Password must not be null.");
            return;
        }
        if (this.getTargetFolder() == null) {
            this.project.log("TargetFolder must not be null.");
            return;
        }
        if (this.getTargetFolder() != null && (this.getTargetFolder().endsWith("/") || this.getTargetFolder().endsWith("\\")) && this.getTargetFolder().length() > 1) {
            this.setTargetFolder(this.getTargetFolder().substring(0, this.getTargetFolder().length() - 1));
        }
        if (this.getFolderName() != null && (this.getFolderName().endsWith("/") || this.getFolderName().endsWith("\\")) && this.getFolderName().length() > 1) {
            this.setFolderName(this.getFolderName().substring(0, this.getFolderName().length() - 1));
        }
        if ((file = new File(this.getTargetFolder())).isDirectory() && !this.getForceAsBoolean()) {
            this.project.log("Target directory exists. Set \"force\" to \"true\" to continue anyway.");
            return;
        }
        try {
            Server server = this.getServer();
            this.runServer(server);
            server.disconnect();
            this.project.log(String.valueOf(this.checkedOut) + " files checked out.");
        }
        catch (Throwable throwable) {
            this.project.log("    " + throwable.getMessage());
        }
    }

    protected String formatForDisplay(Property property, Object object) {
        if (property.getTypeCode() == 8) {
            String string = object.toString();
            if (string.length() > 35) {
                string = String.valueOf(string.substring(0, 32)) + "...";
            }
            return "\"" + string + "\"";
        }
        if (property.getTypeCode() == 2) {
            return "\"" + property.getEnumDisplayName(((Integer)object).intValue()) + "\"";
        }
        return object.toString();
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getForce() {
        return this.force;
    }

    public boolean getForceAsBoolean() {
        return Project.toBoolean((String)this.force);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getPassword() {
        return this.password;
    }

    protected Property getPrimaryDescriptor(Type type) {
        Property[] propertyArray = type.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property.isPrimaryDescriptor()) {
                return property;
            }
            ++n;
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRecursion() {
        return this.recursion;
    }

    public boolean getRecursionAsBoolean() {
        return Project.toBoolean((String)this.recursion);
    }

    protected Property getSecondaryDescriptor(Type type) {
        Property[] propertyArray = type.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property.isDescriptor() && !property.isPrimaryDescriptor()) {
                return property;
            }
            ++n;
        }
        return null;
    }

    protected Server getServer() {
        Server server = new Server(this.getServerName(), this.getServerPortAsInt());
        server.connect();
        server.logOn(this.getUsername(), this.getPassword());
        return server;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public int getServerPortAsInt() {
        return Integer.parseInt(this.serverPort);
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public String getUsername() {
        return this.username;
    }

    public String getVerbose() {
        return this.verbose;
    }

    public boolean getVerboseAsBoolean() {
        return Project.toBoolean((String)this.verbose);
    }

    public String getViewName() {
        return this.viewName;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean match(String var0, String var1_1) {
        var2_2 = var0.toCharArray();
        var3_3 = var1_1.toCharArray();
        var4_4 = 0;
        var5_5 = var2_2.length - 1;
        var6_6 = 0;
        var7_7 = var3_3.length - 1;
        var9_8 = false;
        var10_9 = 0;
        while (var10_9 < var2_2.length) {
            if (var2_2[var10_9] == '*') {
                var9_8 = true;
                break;
            }
            ++var10_9;
        }
        if (!var9_8) {
            if (var5_5 != var7_7) {
                return false;
            }
            var11_10 = 0;
            while (var11_10 <= var5_5) {
                var8_14 = var2_2[var11_10];
                if (var8_14 != '?' && var8_14 != var3_3[var11_10]) {
                    return false;
                }
                ++var11_10;
            }
            return true;
        }
        if (var5_5 != 0) ** GOTO lbl32
        return true;
lbl-1000:
        // 1 sources

        {
            if (var8_15 != '?' && var8_15 != var3_3[var6_6]) {
                return false;
            }
            ++var4_4;
            ++var6_6;
lbl32:
            // 2 sources

            ** while ((var8_15 = var2_2[var4_4]) != '*' && var6_6 <= var7_7)
        }
lbl33:
        // 1 sources

        if (var6_6 <= var7_7) ** GOTO lbl45
        var11_11 = var4_4;
        while (var11_11 <= var5_5) {
            if (var2_2[var11_11] != '*') {
                return false;
            }
            ++var11_11;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (var8_15 != '?' && var8_15 != var3_3[var7_7]) {
                return false;
            }
            --var5_5;
            --var7_7;
lbl45:
            // 2 sources

            ** while ((var8_15 = var2_2[var5_5]) != '*' && var6_6 <= var7_7)
        }
lbl46:
        // 1 sources

        if (var6_6 <= var7_7) ** GOTO lbl86
        var11_12 = var4_4;
        while (var11_12 <= var5_5) {
            if (var2_2[var11_12] != '*') {
                return false;
            }
            ++var11_12;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            var11_13 = -1;
            var12_16 = var4_4 + 1;
            while (var12_16 <= var5_5) {
                if (var2_2[var12_16] == '*') {
                    var11_13 = var12_16;
                    break;
                }
                ++var12_16;
            }
            if (var11_13 == var4_4 + 1) {
                ++var4_4;
                continue;
            }
            var13_17 = var11_13 - var4_4 - 1;
            var14_18 = var7_7 - var6_6 + 1;
            var15_19 = -1;
            var16_20 = 0;
            while (var16_20 <= var14_18 - var13_17) {
                block24: {
                    var17_21 = 0;
                    while (var17_21 < var13_17) {
                        var8_15 = var2_2[var4_4 + var17_21 + 1];
                        if (var8_15 == '?' || var8_15 == var3_3[var6_6 + var16_20 + var17_21]) {
                            ++var17_21;
                            continue;
                        }
                        break block24;
                    }
                    var15_19 = var6_6 + var16_20;
                    break;
                }
                ++var16_20;
            }
            if (var15_19 == -1) {
                return false;
            }
            var4_4 = var11_13;
            var6_6 = var15_19 + var13_17;
lbl86:
            // 3 sources

            ** while (var4_4 != var5_5 && var6_6 <= var7_7)
        }
lbl87:
        // 1 sources

        var11_13 = var4_4;
        while (var11_13 <= var5_5) {
            if (var2_2[var11_13] != '*') {
                return false;
            }
            ++var11_13;
        }
        return true;
    }

    protected void runFolder(Server server, com.starbase.starteam.Project project, View view, Type type, Folder folder) {
        Item[] itemArray = folder.getItems(type.getName());
        int n = 0;
        while (n < itemArray.length) {
            this.runItem(server, project, view, type, folder, itemArray[n]);
            ++n;
        }
        if (this.getRecursionAsBoolean()) {
            Folder[] folderArray = folder.getSubFolders();
            int n2 = 0;
            while (n2 < folderArray.length) {
                this.runFolder(server, project, view, type, folderArray[n2]);
                ++n2;
            }
        }
    }

    protected void runItem(Server server, com.starbase.starteam.Project project, View view, Type type, Folder folder, Item item) {
        int n;
        StringTokenizer stringTokenizer;
        Property property = this.getPrimaryDescriptor(type);
        Property property2 = this.getSecondaryDescriptor(type);
        String string = (String)item.get(property.getName());
        boolean bl = false;
        boolean bl2 = false;
        if (this.getIncludes() != null) {
            stringTokenizer = new StringTokenizer(this.getIncludes(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                if (!AntStarTeamCheckOut.match(stringTokenizer.nextToken(), string)) continue;
                bl = true;
            }
        }
        if (this.getExcludes() != null) {
            stringTokenizer = new StringTokenizer(this.getExcludes(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                if (!AntStarTeamCheckOut.match(stringTokenizer.nextToken(), string)) continue;
                bl2 = true;
            }
        }
        if (bl ^ true | bl2) {
            return;
        }
        if (this.getVerboseAsBoolean()) {
            int n2;
            boolean bl3 = true;
            if (folder != this.prevFolder) {
                String string2 = folder.getFolderHierarchy();
                n = string2.indexOf(this.delim);
                if (n >= 0) {
                    string2 = string2.substring(n + 1);
                }
                System.out.println("            Folder: \"" + string2 + "\"");
                this.prevFolder = folder;
            } else {
                bl3 = false;
            }
            if (bl3) {
                System.out.print("                Item");
                System.out.print(",\t" + property.getDisplayName());
                if (property2 != null) {
                    System.out.print(",\t" + property2.getDisplayName());
                }
                System.out.println("");
            }
            System.out.print("                " + item.getItemID());
            System.out.print(",\t" + this.formatForDisplay(property, item.get(property.getName())));
            if (property2 != null) {
                System.out.print(",\t" + this.formatForDisplay(property2, item.get(property2.getName())));
            }
            if ((n2 = item.getLocker()) > -1) {
                System.out.println(",\tLocked by " + n2);
            } else {
                System.out.println(",\tNot locked");
            }
        }
        com.starbase.starteam.File file = (com.starbase.starteam.File)item;
        String string3 = view.getDefaultPath();
        string3 = string3.replace('\\', '/');
        n = string3.length();
        if (string3.endsWith("/")) {
            --n;
        }
        string3 = string3.substring(string3.lastIndexOf("/", string3.length() - 2) + 1, n);
        StringTokenizer stringTokenizer2 = new StringTokenizer(item.getParentFolder().getFolderHierarchy(), this.delim);
        String string4 = this.delim;
        String string5 = null;
        while (stringTokenizer2.hasMoreTokens()) {
            string5 = stringTokenizer2.nextToken();
            if (string5.equals(this.getProjectName())) {
                string5 = string3;
            }
            string4 = String.valueOf(string4) + string5 + this.delim;
        }
        File file2 = new File(String.valueOf(this.getTargetFolder()) + string4 + item.get(property.getName()));
        try {
            file.checkoutTo(file2, 3, false, true, true);
        }
        catch (Throwable throwable) {
            this.project.log("    " + throwable.getMessage());
        }
        ++this.checkedOut;
    }

    protected void runProject(Server server, com.starbase.starteam.Project project) {
        View[] viewArray = project.getViews();
        int n = 0;
        while (n < viewArray.length) {
            View view = viewArray[n];
            if (view.getName().equals(this.getViewName())) {
                if (this.getVerboseAsBoolean()) {
                    this.project.log("Found " + this.getProjectName() + this.delim + this.getViewName() + this.delim);
                }
                this.runType(server, project, view, server.typeForName(server.getTypeNames().FILE));
                break;
            }
            ++n;
        }
    }

    protected void runServer(Server server) {
        com.starbase.starteam.Project[] projectArray = server.getProjects();
        int n = 0;
        while (n < projectArray.length) {
            com.starbase.starteam.Project project = projectArray[n];
            if (project.getName().equals(this.getProjectName())) {
                if (this.getVerboseAsBoolean()) {
                    this.project.log("Found " + this.getProjectName() + this.delim);
                }
                this.runProject(server, project);
                break;
            }
            ++n;
        }
    }

    protected void runType(Server server, com.starbase.starteam.Project project, View view, Type type) {
        Folder folder = view.getRootFolder();
        if (this.getFolderName() != null) {
            if (this.getFolderName().equals("\\") || this.getFolderName().equals("/")) {
                this.setFolderName(null);
            } else {
                folder = StarTeamFinder.findFolder((Folder)view.getRootFolder(), (String)this.getFolderName());
            }
        }
        if (this.getVerboseAsBoolean() && this.getFolderName() != null) {
            this.project.log("Found " + this.getProjectName() + this.delim + this.getViewName() + this.delim + this.getFolderName() + this.delim + "\n");
        }
        int n = 2;
        Property property = this.getPrimaryDescriptor(type);
        Property property2 = this.getSecondaryDescriptor(type);
        if (property2 != null) {
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        stringArray[n2++] = server.getPropertyNames().OBJECT_ID;
        stringArray[n2++] = property.getName();
        if (property2 != null) {
            stringArray[n2++] = property2.getName();
        }
        folder.populateNow(type.getName(), stringArray, -1);
        this.runFolder(server, project, view, type, folder);
        folder.discardItems(type.getName(), -1);
    }

    public void setExcludes(String string) {
        this.excludes = string;
    }

    public void setFolderName(String string) {
        this.folderName = string;
    }

    public void setForce(String string) {
        this.force = string;
    }

    public void setIncludes(String string) {
        this.includes = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public void setRecursion(String string) {
        this.recursion = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setServerPort(String string) {
        this.serverPort = string;
    }

    public void setTargetFolder(String string) {
        this.targetFolder = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setVerbose(String string) {
        this.verbose = string;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }
}

