/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.AggregateTransformer;
import org.apache.tools.ant.taskdefs.optional.junit.DOMUtil;
import org.apache.tools.ant.taskdefs.optional.junit.XMLConstants;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLResultAggregator
extends Task
implements XMLConstants {
    protected Vector filesets = new Vector();
    protected String toFile;
    protected File toDir;
    protected Vector transformers = new Vector();
    public static final String DEFAULT_DIR = ".";
    public static final String DEFAULT_FILENAME = "TESTS-TestSuites.xml";

    public AggregateTransformer createReport() {
        AggregateTransformer aggregateTransformer = new AggregateTransformer(this);
        this.transformers.add(aggregateTransformer);
        return aggregateTransformer;
    }

    public void setTofile(String string) {
        this.toFile = string;
    }

    public void setTodir(File file) {
        this.toDir = file;
    }

    public void addFileSet(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        Element element = this.createDocument();
        File file = this.getDestinationFile();
        try {
            this.writeDOMTree(element.getOwnerDocument(), file);
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to write test aggregate to '" + file + "'", (Throwable)iOException);
        }
        Enumeration enumeration = this.transformers.elements();
        while (enumeration.hasMoreElements()) {
            AggregateTransformer aggregateTransformer = (AggregateTransformer)enumeration.nextElement();
            aggregateTransformer.setXmlDocument(element.getOwnerDocument());
            aggregateTransformer.transform();
        }
    }

    protected File getDestinationFile() {
        if (this.toFile == null) {
            this.toFile = DEFAULT_FILENAME;
        }
        if (this.toDir == null) {
            this.toDir = this.project.resolveFile(DEFAULT_DIR);
        }
        return new File(this.toDir, this.toFile);
    }

    protected File[] getFiles() {
        FileSet fileSet;
        Vector<File> vector = new Vector<File>();
        int n = this.filesets.size();
        int n2 = 0;
        while (n2 < n) {
            fileSet = (FileSet)this.filesets.elementAt(n2);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string = stringArray[n3];
                if (string.endsWith(".xml")) {
                    File file = new File(directoryScanner.getBasedir(), string);
                    file = this.project.resolveFile(file.getPath());
                    vector.addElement(file);
                }
                ++n3;
            }
            ++n2;
        }
        fileSet = new File[vector.size()];
        vector.copyInto((Object[])fileSet);
        return fileSet;
    }

    protected void writeDOMTree(Document document, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.write("<?xml version=\"1.0\"?>\n");
        new DOMElementWriter().write(document.getDocumentElement(), (Writer)printWriter, 0, "  ");
        printWriter.flush();
        printWriter.close();
        if (printWriter.checkError()) {
            throw new IOException("Error while writing DOM content");
        }
    }

    protected Element createDocument() {
        DocumentBuilder documentBuilder = XMLResultAggregator.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("testsuites");
        document.appendChild(element);
        File[] fileArray = this.getFiles();
        int n = 0;
        while (n < fileArray.length) {
            Object object;
            try {
                this.log("Parsing file: '" + fileArray[n] + "'", 3);
                Document document2 = documentBuilder.parse("file:///" + fileArray[n].getAbsolutePath());
                object = document2.getDocumentElement();
                if ("testsuite".equals(object.getNodeName())) {
                    this.addTestSuite(element, (Element)object);
                } else {
                    this.log("the file " + fileArray[n] + " is not a valid testsuite XML document", 1);
                }
            }
            catch (SAXException sAXException) {
                this.log("The file " + fileArray[n] + " is not a valid XML document. It is possibly corrupted.", 1);
                object = new StringWriter();
                sAXException.printStackTrace(new PrintWriter((Writer)object));
                this.log(((StringWriter)object).toString(), 4);
            }
            catch (IOException iOException) {
                this.log("Error while accessing file " + fileArray[n] + ": " + iOException.getMessage(), 0);
            }
            ++n;
        }
        return element;
    }

    protected void addTestSuite(Element element, Element element2) {
        String string = element2.getAttribute("name");
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        String string3 = n == -1 ? string : string.substring(n + 1);
        Element element3 = (Element)DOMUtil.importNode(element, element2);
        element3.setAttribute("name", string3);
        element3.setAttribute("package", string2);
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

