/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Script
extends Task {
    private String language;
    private String script = "";
    private Hashtable beans = new Hashtable();

    private void addBeans(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = string.length() > 0 && Character.isJavaIdentifierStart(string.charAt(0));
            int n = 1;
            while (bl && n < string.length()) {
                bl = Character.isJavaIdentifierPart(string.charAt(n));
                ++n;
            }
            if (!bl) continue;
            this.beans.put(string, hashtable.get(string));
        }
    }

    public void execute() throws BuildException {
        try {
            this.addBeans(this.project.getProperties());
            this.addBeans(this.project.getUserProperties());
            this.addBeans(this.project.getTargets());
            this.addBeans(this.project.getReferences());
            BSFManager bSFManager = new BSFManager();
            Enumeration enumeration = this.beans.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.beans.get(string);
                bSFManager.declareBean(string, v, v.getClass());
            }
            bSFManager.exec(this.language, "<ANT>", 0, 0, (Object)this.script);
        }
        catch (BSFException bSFException) {
            Throwable throwable = bSFException;
            Throwable throwable2 = bSFException.getTargetException();
            if (throwable2 != null) {
                if (throwable2 instanceof BuildException) {
                    throw (BuildException)throwable2;
                }
                throwable = throwable2;
            }
            throw new BuildException(throwable);
        }
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setSrc(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new BuildException("file " + string + " not found.");
        }
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        this.script = this.script + new String(byArray);
    }

    public void addText(String string) {
        this.script = this.script + string;
    }
}

