/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.QueuedEvents;
import org.apache.xalan.transformer.QueuedStartDocument;
import org.apache.xalan.transformer.QueuedStartElement;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xalan.transformer.TransformState;
import org.apache.xalan.transformer.TransformerClient;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.MutableAttrListImpl;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
LexicalHandler,
TransformState {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    NamespaceSupport m_nsSupport = new NamespaceSupport();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private StylesheetRoot m_stylesheetRoot = null;
    private int m_uniqueNSValue = 0;
    private static final String S_NAMESPACEPREFIX = "ns";
    public ClonerToResultTree m_cloner;
    private TraceManager m_tracer;
    private static final int EVT_SETDOCUMENTLOCATOR = 1;
    private static final int EVT_STARTDOCUMENT = 2;
    private static final int EVT_ENDDOCUMENT = 3;
    private static final int EVT_STARTPREFIXMAPPING = 4;
    private static final int EVT_ENDPREFIXMAPPING = 5;
    private static final int EVT_STARTELEMENT = 6;
    private static final int EVT_ENDELEMENT = 7;
    private static final int EVT_CHARACTERS = 8;
    private static final int EVT_IGNORABLEWHITESPACE = 9;
    private static final int EVT_PROCESSINGINSTRUCTION = 10;
    private static final int EVT_SKIPPEDENTITY = 11;
    private static final int EVT_COMMENT = 12;
    private static final int EVT_ENTITYREF = 13;
    private static final int EVT_STARTENTITY = 14;
    private static final int EVT_ENDENTITY = 15;
    private static final int EVT_STARTDTD = 16;
    private static final int EVT_ENDDTD = 17;
    private static final int EVT_STARTCDATA = 22;
    private static final int EVT_ENDCDATA = 23;
    private static final int EVT_NODE = 24;

    public ResultTreeHandler() {
    }

    public ResultTreeHandler(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.init(transformerImpl, contentHandler);
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws TransformerException {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (!queuedStartElement.nsDeclsHaveBeenAdded()) {
            this.addNSDeclsToAttrs();
        }
        if (string == null) {
            string = "";
        }
        try {
            if (!string3.equals("xmlns")) {
                this.ensurePrefixIsDeclared(string, string3);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        if (!this.isDefinedNSDecl(string3, string5)) {
            queuedStartElement.addAttribute(string, string2, string3, string4, string5);
        }
    }

    public void addAttribute(Attr attr) throws TransformerException {
        if (this.isDefinedNSDecl(attr)) {
            return;
        }
        DOMHelper dOMHelper = this.m_transformer.getXPathContext().getDOMHelper();
        String string = dOMHelper.getNamespaceOfNode(attr);
        if (string == null) {
            string = "";
        }
        this.addAttribute(string, dOMHelper.getLocalNameOfNode(attr), attr.getNodeName(), "CDATA", attr.getValue());
    }

    public void addAttributes(Node node) throws TransformerException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            this.addAttribute(attr);
            ++n2;
        }
    }

    protected void addNSDeclsToAttrs() {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = string.length() == 0;
            String string2 = bl ? "xmlns" : "xmlns:" + string;
            String string3 = this.m_nsSupport.getURI(string);
            if (string3 == null) {
                string3 = "";
            }
            queuedStartElement.addAttribute("http://www.w3.org/2000/xmlns/", string, string2, "CDATA", string3);
        }
        queuedStartElement.setNSDeclsHaveBeenAdded(true);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending(8);
        this.m_contentHandler.characters(cArray, n, n2);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 5, cArray, n, n2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    private void checkForSerializerSwitch(String string, String string2) throws SAXException {
        try {
            QueuedStartDocument queuedStartDocument = this.getQueuedDocAtBottom();
            if (queuedStartDocument.isPending) {
                SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, string, string2);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void cloneToResultTree(Node node, boolean bl) throws SAXException {
        try {
            this.m_cloner.cloneToResultTree(node, bl);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void comment(String string) throws SAXException {
        this.flushPending(12);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(string.toCharArray(), 0, string.length());
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 8, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending(12);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(cArray, n, n2);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 8, new String(cArray, n, n2));
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(23);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(17);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        this.flushPending(3);
        QueuedStartDocument queuedStartDocument = this.getQueuedDocAtBottom();
        if (!queuedStartDocument.isEnded) {
            this.m_contentHandler.endDocument();
            if (this.m_tracer != null) {
                GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 2, null);
                this.m_tracer.fireGenerateEvent(generateEvent);
            }
            queuedStartDocument.setPending(false);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushPending(7);
        this.m_contentHandler.endElement(string, string2, string3);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 4, string3);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void endEntity(String string) throws SAXException {
        this.flushPending(15);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endEntity(string);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 9, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string2.substring(0, n);
            if (!(string4 == null || (string3 = this.m_nsSupport.getURI(string4)) != null && string3.equals(string))) {
                this.startPrefixMapping(string4, string, false);
            }
        }
    }

    public void entityReference(String string) throws SAXException {
        this.flushPending(13);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(string);
            this.m_lexicalHandler.endEntity(string);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 9, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void flushPending() throws SAXException {
        this.flushPending(24);
    }

    public void flushPending(int n) throws SAXException {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        QueuedStartDocument queuedStartDocument = this.getQueuedDocAtBottom();
        if (n != 4 && queuedStartDocument.isPending) {
            queuedStartDocument.flush(this);
        }
        if (queuedStartElement != null && queuedStartElement.isPending) {
            if (!queuedStartElement.nsDeclsHaveBeenAdded()) {
                this.addNSDeclsToAttrs();
            }
            this.sendStartPrefixMappings();
            queuedStartElement.flush();
            this.m_nsContextPushed = false;
        }
    }

    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public NodeIterator getContextNodeList() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null && queuedStartElement.isPending) {
            return queuedStartElement.getContextNodeList();
        }
        return this.m_transformer.getContextNodeList();
    }

    public ElemTemplateElement getCurrentElement() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null && queuedStartElement.isPending) {
            return queuedStartElement.getCurrentElement();
        }
        return this.m_transformer.getCurrentElement();
    }

    public Node getCurrentNode() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null && queuedStartElement.isPending) {
            return queuedStartElement.getCurrentNode();
        }
        return this.m_transformer.getCurrentNode();
    }

    public ElemTemplate getCurrentTemplate() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null && queuedStartElement.isPending) {
            return queuedStartElement.getCurrentTemplate();
        }
        return this.m_transformer.getCurrentTemplate();
    }

    public Node getMatchedNode() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null && queuedStartElement.isPending) {
            return queuedStartElement.getMatchedNode();
        }
        return this.m_transformer.getMatchedNode();
    }

    public ElemTemplate getMatchedTemplate() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null && queuedStartElement.isPending) {
            return queuedStartElement.getMatchedTemplate();
        }
        return this.m_transformer.getMatchedTemplate();
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.getQueuedElem().getAttrs();
    }

    public String getPrefix(String string) {
        Enumeration enumeration = this.m_nsSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.m_nsSupport.getURI(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public String getURI(String string) {
        return this.m_nsSupport.getURI(string);
    }

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        QueuedStartDocument queuedStartDocument = this.getQueuedDoc();
        if (queuedStartDocument != null && queuedStartDocument.isPending && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        this.flushPending(9);
        this.m_contentHandler.ignorableWhitespace(cArray, n, n2);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 6, cArray, n, n2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void init(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.m_transformer = transformerImpl;
        this.m_startElement.setTransformer(this.m_transformer);
        this.m_startDoc.setTransformer(this.m_transformer);
        TraceManager traceManager = transformerImpl.getTraceManager();
        this.m_tracer = traceManager != null && traceManager.hasTraceListeners() ? traceManager : null;
        this.m_startElement.setTraceManager(this.m_tracer);
        this.m_startDoc.setTraceManager(this.m_tracer);
        this.m_contentHandler = contentHandler;
        this.m_startElement.setContentHandler(this.m_contentHandler);
        this.m_startDoc.setContentHandler(this.m_contentHandler);
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_startElement.setIsTransformClient(this.m_contentHandler instanceof TransformerClient);
        this.m_cloner = new ClonerToResultTree(transformerImpl, this);
        if (this.m_transformer != null) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public boolean isDefinedNSDecl(String string, String string2) {
        if (string.equals("xmlns") || string.startsWith("xmlns:")) {
            int n = string.indexOf(":");
            String string3 = n < 0 ? "" : string.substring(0, n);
            String string4 = this.m_nsSupport.getURI(string3);
            if (string4 != null) {
                return string4.equals(string2);
            }
            return false;
        }
        return false;
    }

    public boolean isDefinedNSDecl(Attr attr) {
        int n;
        String string;
        String string2;
        String string3 = attr.getNodeName();
        return (string3.equals("xmlns") || string3.startsWith("xmlns:")) && (string2 = this.getURI(string = (n = string3.indexOf(":")) < 0 ? "" : string3.substring(0, n))) != null && string2.equals(attr.getValue());
    }

    public boolean isElementPending() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        return queuedStartElement != null ? queuedStartElement.isPending : false;
    }

    public void outputResultTreeFragment(XObject xObject, XPathContext xPathContext) throws SAXException {
        DocumentFragment documentFragment = xObject.rtree(xPathContext);
        TreeWalker treeWalker = new TreeWalker(this, xPathContext.getDOMHelper());
        Node node = documentFragment.getFirstChild();
        while (node != null) {
            this.flushPending(24);
            treeWalker.traverse(node);
            node = node.getNextSibling();
        }
    }

    public void processNSDecls(Node node) throws TransformerException {
        try {
            Node node2;
            short s = node.getNodeType();
            if ((s == 1 || s == 5) && (node2 = node.getParentNode()) != null) {
                this.processNSDecls(node2);
            }
            if (s == 1) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node3 = namedNodeMap.item(n2);
                    String string = node3.getNodeName();
                    if (QName.isXMLNSDecl(string)) {
                        String string2 = QName.getPrefixFromXMLNSDecl(string);
                        String string3 = this.getURI(string2);
                        String string4 = node3.getNodeValue();
                        if (!string4.equalsIgnoreCase(string3)) {
                            this.startPrefixMapping(string2, string4, false);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending(10);
        this.m_contentHandler.processingInstruction(string, string2);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 7, string, string2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.endPrefixMapping(string);
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.startPrefixMapping(string, this.m_nsSupport.getURI(string));
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
        this.m_startElement.setIsTransformClient(this.m_contentHandler instanceof TransformerClient);
        this.m_startElement.setContentHandler(this.m_contentHandler);
        this.m_startDoc.setContentHandler(this.m_contentHandler);
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.reInitEvents();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.flushPending(22);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushPending(16);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        this.checkForSerializerSwitch(string, string2);
        this.flushPending(6);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
        }
        this.ensurePrefixIsDeclared(string, string3);
        this.pushElementEvent(string, string2, string3, attributes);
    }

    public void startEntity(String string) throws SAXException {
        this.flushPending(14);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(string);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    public void startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        String string3;
        if (bl) {
            this.flushPending(4);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (string == null) {
            string = "";
        }
        if ((string3 = this.m_nsSupport.getURI(string)) == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!string3.equals(string2)) {
            this.m_nsSupport.declarePrefix(string, string2);
        }
    }
}

