; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define ptr @vst2_v4i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst20.32 {q0, q1}, [r1]
; CHECK-NEXT:    vst21.32 {q0, q1}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i32>, ptr %src, align 4
  %s2 = getelementptr <4 x i32>, ptr %src, i32 1
  %l2 = load <4 x i32>, ptr %s2, align 4
  %s = shufflevector <4 x i32> %l1, <4 x i32> %l2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  store <8 x i32> %s, ptr %dst
  %ret = getelementptr inbounds <8 x i32>, ptr %dst, i32 1
  ret ptr %ret
}

; i16

define ptr @vst2_v8i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst20.16 {q0, q1}, [r1]
; CHECK-NEXT:    vst21.16 {q0, q1}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i16>, ptr %src, align 4
  %s2 = getelementptr <8 x i16>, ptr %src, i32 1
  %l2 = load <8 x i16>, ptr %s2, align 4
  %s = shufflevector <8 x i16> %l1, <8 x i16> %l2, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  store <16 x i16> %s, ptr %dst
  %ret = getelementptr inbounds <16 x i16>, ptr %dst, i32 1
  ret ptr %ret
}

; i8

define ptr @vst2_v16i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst20.8 {q0, q1}, [r1]
; CHECK-NEXT:    vst21.8 {q0, q1}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i8>, ptr %src, align 4
  %s2 = getelementptr <16 x i8>, ptr %src, i32 1
  %l2 = load <16 x i8>, ptr %s2, align 4
  %s = shufflevector <16 x i8> %l1, <16 x i8> %l2, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  store <32 x i8> %s, ptr %dst
  %ret = getelementptr inbounds <32 x i8>, ptr %dst, i32 1
  ret ptr %ret
}

; i64

define ptr @vst2_v2i64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov.f64 d5, d0
; CHECK-NEXT:    vmov.f64 d0, d3
; CHECK-NEXT:    vmov.f64 d4, d2
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vstrw.32 q2, [r1], #32
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x i64>, ptr %src, align 4
  %s2 = getelementptr <2 x i64>, ptr %src, i32 1
  %l2 = load <2 x i64>, ptr %s2, align 4
  %s = shufflevector <2 x i64> %l1, <2 x i64> %l2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  store <4 x i64> %s, ptr %dst
  %ret = getelementptr inbounds <4 x i64>, ptr %dst, i32 1
  ret ptr %ret
}

; f32

define ptr @vst2_v4f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst20.32 {q0, q1}, [r1]
; CHECK-NEXT:    vst21.32 {q0, q1}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x float>, ptr %src, align 4
  %s2 = getelementptr <4 x float>, ptr %src, i32 1
  %l2 = load <4 x float>, ptr %s2, align 4
  %s = shufflevector <4 x float> %l1, <4 x float> %l2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  store <8 x float> %s, ptr %dst
  %ret = getelementptr inbounds <8 x float>, ptr %dst, i32 1
  ret ptr %ret
}

; f16

define ptr @vst2_v8f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst20.16 {q0, q1}, [r1]
; CHECK-NEXT:    vst21.16 {q0, q1}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x half>, ptr %src, align 4
  %s2 = getelementptr <8 x half>, ptr %src, i32 1
  %l2 = load <8 x half>, ptr %s2, align 4
  %s = shufflevector <8 x half> %l1, <8 x half> %l2, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  store <16 x half> %s, ptr %dst
  %ret = getelementptr inbounds <16 x half>, ptr %dst, i32 1
  ret ptr %ret
}

; f64

define ptr @vst2_v2f64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst2_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov.f64 d5, d0
; CHECK-NEXT:    vmov.f64 d0, d3
; CHECK-NEXT:    vmov.f64 d4, d2
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vstrw.32 q2, [r1], #32
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x double>, ptr %src, align 4
  %s2 = getelementptr <2 x double>, ptr %src, i32 1
  %l2 = load <2 x double>, ptr %s2, align 4
  %s = shufflevector <2 x double> %l1, <2 x double> %l2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  store <4 x double> %s, ptr %dst
  %ret = getelementptr inbounds <4 x double>, ptr %dst, i32 1
  ret ptr %ret
}
