; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -march=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6 %s
; RUN: llc -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s

declare double @llvm.convert.from.fp16.f64(i16) nounwind readnone

define amdgpu_kernel void @test_convert_fp16_to_fp64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; GFX6-LABEL: test_convert_fp16_to_fp64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_convert_fp16_to_fp64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_mov_b32 s10, s6
; GFX8-NEXT:    s_mov_b32 s11, s7
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: test_convert_fp16_to_fp64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_u16 v0, off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %val = load i16, ptr addrspace(1) %in, align 2
  %cvt = call double @llvm.convert.from.fp16.f64(i16 %val) nounwind readnone
  store double %cvt, ptr addrspace(1) %out, align 4
  ret void
}
