; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc %s -o - -verify-machineinstrs -mtriple=arm64-none-linux-gnu | FileCheck %s

; This is the analogue of AArch64's file of the same name. It's mostly testing
; some form of correct lowering occurs, the tests are a little artificial but I
; strongly suspect there's room for improved CodeGen (FIXME).

define i64 @test_sext_extr_cmp_0(<1 x i64> %v1, <1 x i64> %v2) {
; CHECK-LABEL: test_sext_extr_cmp_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fmov x8, d1
; CHECK-NEXT:    fmov x9, d0
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    cset w8, ge
; CHECK-NEXT:    sbfx x0, x8, #0, #1
; CHECK-NEXT:    ret
  %1 = icmp sge <1 x i64> %v1, %v2
  %2 = extractelement <1 x i1> %1, i32 0
  %vget_lane = sext i1 %2 to i64
  ret i64 %vget_lane
}

define i64 @test_sext_extr_cmp_1(<1 x double> %v1, <1 x double> %v2) {
; CHECK-LABEL: test_sext_extr_cmp_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmp d0, d1
; CHECK-NEXT:    cset w8, eq
; CHECK-NEXT:    sbfx x0, x8, #0, #1
; CHECK-NEXT:    ret
  %1 = fcmp oeq <1 x double> %v1, %v2
  %2 = extractelement <1 x i1> %1, i32 0
  %vget_lane = sext i1 %2 to i64
  ret i64 %vget_lane
}

define <1 x i64> @test_select_v1i1_0(<1 x i64> %v1, <1 x i64> %v2, <1 x i64> %v3) {
; CHECK-LABEL: test_select_v1i1_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq d0, d0, d1
; CHECK-NEXT:    bic v0.8b, v2.8b, v0.8b
; CHECK-NEXT:    ret
  %1 = icmp eq <1 x i64> %v1, %v2
  %res = select <1 x i1> %1, <1 x i64> zeroinitializer, <1 x i64> %v3
  ret <1 x i64> %res
}

define <1 x i64> @test_select_v1i1_1(<1 x double> %v1, <1 x double> %v2, <1 x i64> %v3) {
; CHECK-LABEL: test_select_v1i1_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq d0, d0, d1
; CHECK-NEXT:    bic v0.8b, v2.8b, v0.8b
; CHECK-NEXT:    ret
  %1 = fcmp oeq <1 x double> %v1, %v2
  %res = select <1 x i1> %1, <1 x i64> zeroinitializer, <1 x i64> %v3
  ret <1 x i64> %res
}

define <1 x double> @test_select_v1i1_2(<1 x i64> %v1, <1 x i64> %v2, <1 x double> %v3) {
; CHECK-LABEL: test_select_v1i1_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq d0, d0, d1
; CHECK-NEXT:    bic v0.8b, v2.8b, v0.8b
; CHECK-NEXT:    ret
  %1 = icmp eq <1 x i64> %v1, %v2
  %res = select <1 x i1> %1, <1 x double> zeroinitializer, <1 x double> %v3
  ret <1 x double> %res
}

; For v1i64, it's not clear which of the vector or scalar compare is better.
; Let's stick to the vector form, like for all other vector selects fed by a
; scalar setcc.  If anything, it exposes more ILP.
define <1 x i64> @test_select_v1i1_3(i64 %lhs, i64 %rhs, <1 x i64> %v3) {
; CHECK-LABEL: test_select_v1i1_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d1, x1
; CHECK-NEXT:    fmov d2, x0
; CHECK-NEXT:    cmeq d1, d2, d1
; CHECK-NEXT:    bic v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tst = icmp eq i64 %lhs, %rhs
  %evil = insertelement <1 x i1> undef, i1 %tst, i32 0
  %res = select <1 x i1> %evil, <1 x i64> zeroinitializer, <1 x i64> %v3
  ret <1 x i64> %res
}

define i32 @test_br_extr_cmp(<1 x i64> %v1, <1 x i64> %v2) {
; CHECK-LABEL: test_br_extr_cmp:
; CHECK:       // %bb.0: // %common.ret
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fmov x8, d1
; CHECK-NEXT:    fmov x9, d0
; CHECK-NEXT:    cmp x9, x8
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %1 = icmp eq <1 x i64> %v1, %v2
  %2 = extractelement <1 x i1> %1, i32 0
  br i1 %2, label %if.end, label %if.then

if.then:
  ret i32 0;

if.end:
  ret i32 1;
}
