/* SPDX-License-Identifier: GPL-2.0 */
/*
* Copyright (c) 2016 MediaTek Inc.
* Author: PC Chen <pc.chen@mediatek.com>
*	Tiffany Lin <tiffany.lin@mediatek.com>
*/

#ifndef _MTK_VCODEC_UTIL_H_
#define _MTK_VCODEC_UTIL_H_

#include <linux/types.h>
#include <linux/dma-direction.h>

struct mtk_vcodec_mem {
	size_t size;
	void *va;
	dma_addr_t dma_addr;
};

struct mtk_vcodec_fb {
	size_t size;
	dma_addr_t dma_addr;
};

struct mtk_vcodec_ctx;
struct mtk_vcodec_dev;

#undef pr_fmt
#define pr_fmt(fmt) "%s(),%d: " fmt, __func__, __LINE__

#define mtk_v4l2_err(fmt, args...)                \
	pr_err("[MTK_V4L2][ERROR] " fmt "\n", ##args)

#define mtk_vcodec_err(inst_id, plat_dev, fmt, args...)                                 \
	dev_err(&(plat_dev)->dev, "[MTK_VCODEC][ERROR][%d]: " fmt "\n", inst_id, ##args)

#if defined(CONFIG_DEBUG_FS)
extern int mtk_v4l2_dbg_level;
extern int mtk_vcodec_dbg;

#define mtk_v4l2_debug(level, fmt, args...)				\
	do {								\
		if (mtk_v4l2_dbg_level >= (level))			\
			pr_debug("[MTK_V4L2] %s, %d: " fmt "\n",        \
				 __func__, __LINE__, ##args);	        \
	} while (0)

#define mtk_vcodec_debug(inst_id, plat_dev, fmt, args...)		\
	do {											\
		if (mtk_vcodec_dbg)								\
			dev_dbg(&(plat_dev)->dev, "[MTK_VCODEC][%d]: %s, %d " fmt "\n",		\
				inst_id, __func__, __LINE__, ##args);				\
	} while (0)
#else
#define mtk_v4l2_debug(level, fmt, args...) pr_debug(fmt, ##args)

#define mtk_vcodec_debug(inst_id, plat_dev, fmt, args...)				\
	dev_dbg(&(plat_dev)->dev, "[MTK_VCODEC][%d]: " fmt "\n", inst_id, ##args)
#endif

#define mtk_vdec_err(ctx, fmt, args...)					\
	mtk_vcodec_err((ctx)->id, (ctx)->dev->plat_dev, fmt, ##args)

#define mtk_vdec_debug(ctx, fmt, args...)				\
	mtk_vcodec_debug((ctx)->id, (ctx)->dev->plat_dev, fmt, ##args)

#define mtk_venc_err(ctx, fmt, args...)					\
	mtk_vcodec_err((ctx)->id, (ctx)->dev->plat_dev, fmt, ##args)

#define mtk_venc_debug(ctx, fmt, args...)				\
	mtk_vcodec_debug((ctx)->id, (ctx)->dev->plat_dev, fmt, ##args)

#define mtk_v4l2_debug_enter()  mtk_v4l2_debug(3, "+")
#define mtk_v4l2_debug_leave()  mtk_v4l2_debug(3, "-")

#define mtk_vcodec_debug_enter(h)  mtk_vcodec_debug(h, "+")
#define mtk_vcodec_debug_leave(h)  mtk_vcodec_debug(h, "-")

void __iomem *mtk_vcodec_get_reg_addr(void __iomem **reg_base, unsigned int reg_idx);
int mtk_vcodec_write_vdecsys(struct mtk_vcodec_ctx *ctx, unsigned int reg, unsigned int val);
int mtk_vcodec_mem_alloc(void *priv, struct mtk_vcodec_mem *mem);
void mtk_vcodec_mem_free(void *priv, struct mtk_vcodec_mem *mem);
void mtk_vcodec_set_curr_ctx(struct mtk_vcodec_dev *vdec_dev,
			     struct mtk_vcodec_ctx *ctx, int hw_idx);
struct mtk_vcodec_ctx *mtk_vcodec_get_curr_ctx(struct mtk_vcodec_dev *vdec_dev,
					       unsigned int hw_idx);
void *mtk_vcodec_get_hw_dev(struct mtk_vcodec_dev *dev, int hw_idx);

#endif /* _MTK_VCODEC_UTIL_H_ */
