/*
 * Copyright (C) 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * Test vectors are obtained from
 * https://pages.nist.gov/ACVP/draft-celi-acvp-ml-dsa.html#name-known-answer-tests
 */

#ifndef DILITHIUM_REJECTION_UPSTREAM_VECTORS_87_H
#define DILITHIUM_REJECTION_UPSTREAM_VECTORS_87_H

#include "dilithium_type.h"

#ifdef __cplusplus
extern "C" {
#endif

struct dilithium_rejection_testvector {
	uint8_t seed[LC_DILITHIUM_SEEDBYTES];
	uint8_t pk[LC_DILITHIUM_PUBLICKEYBYTES];
	uint8_t sk[LC_DILITHIUM_SECRETKEYBYTES];
	uint8_t key_hash[LC_SHA256_SIZE_DIGEST];
	uint8_t msg[32];
	uint8_t sig_hash[LC_SHA256_SIZE_DIGEST];
	uint8_t sig[LC_DILITHIUM_CRYPTO_BYTES];
};

static const struct dilithium_rejection_testvector dilithium_rejection_testvectors[] = {
	{
		/* Data from Table 1 */
		.seed = { 0x5A, 0xC6, 0x8A, 0x41, 0x71, 0x73, 0x0B, 0x1E,
			  0x92, 0x0C, 0xC3, 0xE7, 0xCC, 0x4A, 0xCA, 0x79,
			  0xC2, 0x5A, 0x36, 0x21, 0x00, 0x57, 0x37, 0x3B,
			  0x6B, 0xCE, 0xBC, 0xDF, 0xA1, 0x44, 0xCE, 0x18 },
		.key_hash = { 0x24, 0x46, 0xAB, 0x05, 0xEE, 0xC3, 0x97, 0x7C,
			      0x40, 0x65, 0x03, 0x38, 0x98, 0x3E, 0xEB, 0xF7,
			      0x89, 0x42, 0xAC, 0x31, 0xF5, 0xE9, 0x44, 0x54,
			      0x3E, 0x87, 0xDB, 0xAC, 0x0A, 0x48, 0x89, 0xC1 },
		.msg = { 0x17, 0x2F, 0x6D, 0x49, 0xAF, 0x75, 0x79, 0x18,
			 0x82, 0x3A, 0x75, 0xE9, 0x81, 0xD6, 0x05, 0xDD,
			 0xAF, 0x74, 0xBF, 0x21, 0x00, 0x9A, 0xC8, 0x36,
			 0xD8, 0xB4, 0xC0, 0xAA, 0xBB, 0x49, 0xC1, 0x4C },
		.sig_hash = { 0x37, 0x84, 0x75, 0x5A, 0xC5, 0xA2, 0xD5, 0x72,
			      0x06, 0x23, 0xE5, 0x04, 0x70, 0x7C, 0x30, 0x88,
			      0x61, 0xEF, 0x41, 0x77, 0xA6, 0x46, 0x0F, 0xBE,
			      0xB4, 0xDB, 0x25, 0x7A, 0xAA, 0x24, 0x5B, 0x55 },
	},
	{
		.seed = { 0xE4, 0x5F, 0x9C, 0xC0, 0x43, 0xC2, 0xC0, 0xF4,
			  0xBE, 0xBC, 0xAD, 0x28, 0x60, 0xCA, 0xDF, 0x77,
			  0xC8, 0x21, 0x12, 0x37, 0xD7, 0xAA, 0xA1, 0x08,
			  0xA5, 0x6E, 0x3A, 0xCA, 0x92, 0xD2, 0x07, 0xF7 },
		.key_hash = { 0xF5, 0xB7, 0x27, 0xCA, 0x02, 0xB6, 0xF3, 0x02,
			      0x51, 0x35, 0x92, 0x6A, 0x5F, 0xCA, 0x2A, 0x64,
			      0xA8, 0x00, 0x57, 0x9C, 0xBF, 0xD4, 0x48, 0x63,
			      0xA0, 0x8A, 0xBA, 0x5F, 0xE6, 0xC3, 0x3B, 0x46 },
		.msg = { 0x86, 0xB5, 0xA9, 0x36, 0x1F, 0x73, 0x42, 0x7E,
			 0xBA, 0x3E, 0xEF, 0x5D, 0x46, 0x11, 0x2B, 0x74,
			 0x67, 0xCE, 0xDF, 0xBC, 0xC7, 0x7E, 0xF3, 0x6C,
			 0x94, 0xEF, 0x06, 0x66, 0xC1, 0xAD, 0x37, 0xB6 },
		.sig_hash = { 0xE8, 0x27, 0x6B, 0xF4, 0xD5, 0x77, 0x52, 0xD7,
			      0x7C, 0x6E, 0xAE, 0x2B, 0x80, 0x05, 0x0E, 0xD2,
			      0x0C, 0xF1, 0x53, 0x44, 0xB6, 0x9E, 0x51, 0x50,
			      0xF9, 0x47, 0x92, 0x90, 0x3E, 0xA3, 0x79, 0x0A },
	},
	{
		.seed = { 0x5E, 0x37, 0xA1, 0x43, 0xC0, 0xFF, 0xAE, 0xF6,
			  0x00, 0xF3, 0x3C, 0x37, 0x65, 0x89, 0x06, 0x9A,
			  0x7A, 0x0C, 0xE2, 0xFA, 0xC3, 0x6D, 0xBE, 0xFE,
			  0xC4, 0x2C, 0x5A, 0x60, 0x16, 0x7D, 0x5A, 0x12 },
		.key_hash = { 0xC2, 0x10, 0x31, 0x2C, 0x24, 0x2E, 0x06, 0x42,
			      0xF9, 0x90, 0x32, 0x8A, 0xBF, 0xCD, 0x11, 0x89,
			      0xD2, 0x4E, 0xB8, 0xE9, 0xC1, 0x22, 0xBB, 0x6D,
			      0xFE, 0xFC, 0xF0, 0x2D, 0x4F, 0xCF, 0x62, 0x24 },
		.msg = { 0x9A, 0x72, 0xDF, 0xEB, 0x5C, 0xDA, 0xD4, 0x3D,
			 0x3A, 0x41, 0x6F, 0x8A, 0xD7, 0xB6, 0x67, 0x6D,
			 0x55, 0x28, 0xDD, 0xDA, 0x66, 0x1C, 0x35, 0x13,
			 0xB6, 0xA4, 0x60, 0xDB, 0x74, 0x33, 0x1F, 0x51 },
		.sig_hash = { 0xB3, 0x9E, 0x81, 0x11, 0x51, 0x60, 0x02, 0x6D,
			      0xA5, 0x52, 0x8C, 0x40, 0xB9, 0x0E, 0xA1, 0x46,
			      0x64, 0xBF, 0xC2, 0x2E, 0x26, 0x10, 0x23, 0xA7,
			      0xDC, 0x41, 0x94, 0x51, 0x28, 0x8E, 0xD9, 0x3F },
	},
	{
		.seed = { 0x51, 0xDF, 0x52, 0x0B, 0x90, 0x84, 0xE4, 0x8B,
			  0x72, 0xEA, 0xEB, 0xA7, 0xFE, 0x36, 0xB5, 0x40,
			  0x05, 0xCD, 0x96, 0x3B, 0x58, 0xCC, 0x25, 0xDE,
			  0x79, 0x33, 0x99, 0x48, 0xFD, 0x56, 0x10, 0x65 },
		.key_hash = { 0x3E, 0xCF, 0x7F, 0x6A, 0x89, 0x38, 0x72, 0x91,
			      0x18, 0xCC, 0x21, 0xA1, 0x5B, 0x2B, 0x59, 0x33,
			      0x7B, 0x24, 0xFD, 0x34, 0x38, 0xFB, 0x13, 0x2D,
			      0x01, 0x62, 0xE5, 0x3C, 0x28, 0xCB, 0x37, 0x4C },
		.msg = { 0x28, 0xEF, 0xCA, 0xD1, 0xC1, 0xB5, 0x28, 0xE0,
			 0xE4, 0x6C, 0xB2, 0x5D, 0x28, 0xFA, 0x21, 0xDB,
			 0xA8, 0x93, 0x01, 0x0B, 0x3C, 0x74, 0x1D, 0x73,
			 0x14, 0x60, 0x98, 0x8B, 0x66, 0x98, 0x5D, 0x78 },
		.sig_hash = { 0x02, 0xFA, 0x4C, 0xF7, 0xBF, 0x7F, 0x5B, 0xD1,
			      0x38, 0x74, 0xC7, 0x7B, 0x30, 0xDA, 0xF7, 0x08,
			      0xBA, 0xA3, 0xE2, 0xC0, 0x97, 0xD4, 0x29, 0x8B,
			      0xF2, 0x42, 0xA0, 0x7B, 0xF6, 0x8D, 0x7A, 0xD6 },
	},
	{
		.seed = { 0x68, 0x57, 0xAF, 0x5C, 0x87, 0x8E, 0xFF, 0x78,
			  0x92, 0xF1, 0x72, 0x2D, 0x8C, 0xE1, 0x1F, 0x47,
			  0x84, 0xB9, 0xD1, 0x44, 0xB5, 0x0B, 0x23, 0xB5,
			  0x30, 0x70, 0x96, 0x3B, 0x50, 0x10, 0x54, 0xE6 },
		.key_hash = { 0x9A, 0x2B, 0x47, 0xD3, 0x46, 0x24, 0xBA, 0x79,
			      0x7E, 0xCE, 0x8C, 0x7C, 0x67, 0xFA, 0xAD, 0xB2,
			      0xB2, 0xDA, 0x6C, 0x5C, 0x80, 0x2B, 0x3C, 0xFB,
			      0x22, 0xD8, 0x16, 0x7F, 0x4B, 0x52, 0xD6, 0xEB },
		.msg = { 0x31, 0x65, 0x11, 0x8C, 0x13, 0x5D, 0x81, 0xE4,
			 0x67, 0x00, 0xB1, 0x82, 0x80, 0xA8, 0xD0, 0x1D,
			 0xF3, 0x9A, 0x4B, 0x1A, 0x9C, 0x24, 0x74, 0x8A,
			 0xEE, 0x3F, 0xC3, 0x20, 0x62, 0xDD, 0x25, 0x1E },
		.sig_hash = { 0x69, 0x7E, 0x02, 0xD5, 0x01, 0x85, 0xF9, 0x6C,
			      0x42, 0x00, 0x15, 0xF1, 0xC0, 0x3A, 0x2D, 0xD4,
			      0x64, 0x59, 0x3E, 0x0A, 0xBD, 0x04, 0x93, 0xE0,
			      0x99, 0xD8, 0x77, 0x4B, 0x26, 0xC3, 0x0C, 0x2F },
	},
	{
		/* Data from Table 2 */
		.seed = { 0xC4, 0xB6, 0x14, 0xE8, 0x3C, 0xF6, 0xE2, 0x5A,
			  0x15, 0x9A, 0x54, 0x2B, 0x9E, 0x13, 0x2A, 0xA0,
			  0x68, 0xFA, 0xCC, 0xD8, 0x75, 0x5A, 0xA8, 0xB4,
			  0xE2, 0x2C, 0x6F, 0x6C, 0x04, 0x38, 0xBF, 0x16 },
		.key_hash = { 0x5B, 0xCA, 0xD0, 0x35, 0x7C, 0x6F, 0x39, 0x11,
			      0x68, 0xB0, 0x05, 0x23, 0xCD, 0x7B, 0x13, 0x33,
			      0x5F, 0x95, 0x99, 0x6B, 0xF5, 0x43, 0x25, 0x45,
			      0x54, 0x84, 0xB8, 0x30, 0x15, 0x92, 0x55, 0x80 },
		.msg = { 0xB9, 0xCF, 0xA2, 0x45, 0xC9, 0x03, 0x59, 0xEF,
			 0x04, 0x11, 0x63, 0xA4, 0x72, 0x31, 0x88, 0x5E,
			 0x56, 0xCB, 0x02, 0x15, 0x98, 0x4D, 0xE8, 0xA8,
			 0x99, 0x41, 0xFE, 0x44, 0x3C, 0xAC, 0xEB, 0x61 },
		.sig_hash = { 0x5B, 0x23, 0xE5, 0xCE, 0xC5, 0xB0, 0x91, 0x34,
			      0x2E, 0xF7, 0xD5, 0xBB, 0x8C, 0x50, 0x28, 0x5A,
			      0x96, 0x66, 0xCF, 0x93, 0x7B, 0xBE, 0x17, 0x58,
			      0x53, 0x2B, 0x34, 0x1B, 0x09, 0x42, 0x99, 0x4B },
	},
	{
		.seed = { 0x77, 0x1E, 0x95, 0x43, 0x4E, 0x41, 0x02, 0x91,
			  0x93, 0xD0, 0x76, 0xB8, 0x06, 0xF2, 0xC3, 0xC2,
			  0x2A, 0x7F, 0x20, 0x60, 0x28, 0x77, 0x91, 0xE7,
			  0x0F, 0x10, 0x5E, 0xCA, 0xEA, 0xB7, 0xAD, 0x69 },
		.key_hash = { 0xC5, 0x6A, 0x92, 0x4B, 0xF6, 0xB0, 0x46, 0xDA,
			      0x3C, 0xAC, 0xC1, 0x0B, 0x72, 0x74, 0x9E, 0xCF,
			      0x54, 0x26, 0x6B, 0x38, 0xA7, 0xE3, 0xD5, 0xC5,
			      0x81, 0xD0, 0xA4, 0x4F, 0x1F, 0x39, 0x95, 0xD8 },
		.msg = { 0xC3, 0x67, 0x38, 0x2D, 0x0E, 0x3F, 0xEE, 0x86,
			 0xD2, 0x9B, 0xAB, 0x0E, 0xE5, 0xFD, 0x6A, 0xE9,
			 0x1B, 0x3A, 0x5A, 0x70, 0x17, 0xA0, 0x24, 0xCF,
			 0x14, 0x5A, 0x25, 0xF5, 0x6A, 0x62, 0xB0, 0xB1 },
		.sig_hash = { 0x49, 0x96, 0xF7, 0x74, 0x3E, 0x90, 0xDA, 0xEB,
			      0x61, 0xB5, 0xFF, 0x86, 0xA8, 0x68, 0xC9, 0xE5,
			      0x19, 0x5F, 0x20, 0x1C, 0x4E, 0x5F, 0x5A, 0x75,
			      0xF4, 0xC7, 0x90, 0x31, 0xAA, 0xA6, 0xC5, 0x44 },
	}
};

#ifdef __cplusplus
}
#endif

#endif /* DILITHIUM_REJECTION_UPSTREAM_VECTORS_87_H */
