/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.MacroException;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Macros {
    private Hashtable macros = new Hashtable();
    private Hashtable used = new Hashtable();

    public boolean insert(String string, RegExp regExp) {
        this.used.put(string, new Boolean(false));
        return this.macros.put(string, regExp) == null;
    }

    public boolean markUsed(String string) {
        return this.used.put(string, new Boolean(true)) != null;
    }

    public boolean isUsed(String string) {
        return (Boolean)this.used.get(string);
    }

    public Enumeration unused() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.used.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl = (Boolean)this.used.get(string);
            if (bl.booleanValue()) continue;
            vector.addElement(string);
        }
        return vector.elements();
    }

    public RegExp getDefinition(String string) {
        return (RegExp)this.macros.get(string);
    }

    public void expand() throws MacroException {
        Enumeration enumeration = this.macros.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isUsed(string)) continue;
            this.macros.put(string, this.expandMacro(string, this.getDefinition(string)));
        }
    }

    private RegExp expandMacro(String string, RegExp regExp) throws MacroException {
        switch (regExp.type) {
            case 6: 
            case 44: {
                RegExp2 regExp2 = (RegExp2)regExp;
                regExp2.r1 = this.expandMacro(string, regExp2.r1);
                regExp2.r2 = this.expandMacro(string, regExp2.r2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                RegExp1 regExp1 = (RegExp1)regExp;
                regExp1.content = this.expandMacro(string, (RegExp)regExp1.content);
                break;
            }
            case 40: {
                String string2 = (String)((RegExp1)regExp).content;
                if (string.equals(string2)) {
                    throw new MacroException("Macro " + string + " contains a cycle");
                }
                RegExp regExp2 = this.getDefinition(string2);
                if (regExp2 == null) {
                    throw new MacroException("Found no definition for {" + string2 + "} while expanding {" + string + "}");
                }
                this.markUsed(string2);
                return this.expandMacro(string, regExp2);
            }
        }
        return regExp;
    }
}

