// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.7.2 with parameter "target=js+dts"
// @generated from file livekit_sip.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3 } from "@bufbuild/protobuf";

/**
 * @generated from message livekit.CreateSIPTrunkRequest
 */
export declare class CreateSIPTrunkRequest extends Message<CreateSIPTrunkRequest> {
  /**
   * CIDR or IPs that traffic is accepted from
   * An empty list means all inbound traffic is accepted.
   *
   * @generated from field: repeated string inbound_addresses = 1;
   */
  inboundAddresses: string[];

  /**
   * IP that SIP INVITE is sent too
   *
   * @generated from field: string outbound_address = 2;
   */
  outboundAddress: string;

  /**
   * Number used to make outbound calls
   *
   * @generated from field: string outbound_number = 3;
   */
  outboundNumber: string;

  /**
   * Accepted `To` values. This Trunk will only accept a call made to
   * these numbers. This allows you to have distinct Trunks for different phone
   * numbers at the same provider.
   *
   * @generated from field: repeated string inbound_numbers_regex = 4;
   */
  inboundNumbersRegex: string[];

  /**
   * Username and password used to authenticate inbound and outbound SIP invites
   * May be empty to have no Authentication
   *
   * @generated from field: string inbound_username = 5;
   */
  inboundUsername: string;

  /**
   * @generated from field: string inbound_password = 6;
   */
  inboundPassword: string;

  /**
   * @generated from field: string outbound_username = 7;
   */
  outboundUsername: string;

  /**
   * @generated from field: string outbound_password = 8;
   */
  outboundPassword: string;

  constructor(data?: PartialMessage<CreateSIPTrunkRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.CreateSIPTrunkRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateSIPTrunkRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateSIPTrunkRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateSIPTrunkRequest;

  static equals(a: CreateSIPTrunkRequest | PlainMessage<CreateSIPTrunkRequest> | undefined, b: CreateSIPTrunkRequest | PlainMessage<CreateSIPTrunkRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.SIPTrunkInfo
 */
export declare class SIPTrunkInfo extends Message<SIPTrunkInfo> {
  /**
   * @generated from field: string sip_trunk_id = 1;
   */
  sipTrunkId: string;

  /**
   * CIDR or IPs that traffic is accepted from
   * An empty list means all inbound traffic is accepted.
   *
   * @generated from field: repeated string inbound_addresses = 2;
   */
  inboundAddresses: string[];

  /**
   * IP that SIP INVITE is sent too
   *
   * @generated from field: string outbound_address = 3;
   */
  outboundAddress: string;

  /**
   * Number used to make outbound calls
   *
   * @generated from field: string outbound_number = 4;
   */
  outboundNumber: string;

  /**
   * Accepted `To` values. This Trunk will only accept a call made to
   * these numbers. This allows you to have distinct Trunks for different phone
   * numbers at the same provider.
   *
   * @generated from field: repeated string inbound_numbers_regex = 5;
   */
  inboundNumbersRegex: string[];

  /**
   * Username and password used to authenticate inbound and outbound SIP invites
   * May be empty to have no Authentication
   *
   * @generated from field: string inbound_username = 6;
   */
  inboundUsername: string;

  /**
   * @generated from field: string inbound_password = 7;
   */
  inboundPassword: string;

  /**
   * @generated from field: string outbound_username = 8;
   */
  outboundUsername: string;

  /**
   * @generated from field: string outbound_password = 9;
   */
  outboundPassword: string;

  constructor(data?: PartialMessage<SIPTrunkInfo>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.SIPTrunkInfo";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SIPTrunkInfo;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SIPTrunkInfo;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SIPTrunkInfo;

  static equals(a: SIPTrunkInfo | PlainMessage<SIPTrunkInfo> | undefined, b: SIPTrunkInfo | PlainMessage<SIPTrunkInfo> | undefined): boolean;
}

/**
 * @generated from message livekit.ListSIPTrunkRequest
 */
export declare class ListSIPTrunkRequest extends Message<ListSIPTrunkRequest> {
  constructor(data?: PartialMessage<ListSIPTrunkRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ListSIPTrunkRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListSIPTrunkRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListSIPTrunkRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListSIPTrunkRequest;

  static equals(a: ListSIPTrunkRequest | PlainMessage<ListSIPTrunkRequest> | undefined, b: ListSIPTrunkRequest | PlainMessage<ListSIPTrunkRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.ListSIPTrunkResponse
 */
export declare class ListSIPTrunkResponse extends Message<ListSIPTrunkResponse> {
  /**
   * @generated from field: repeated livekit.SIPTrunkInfo items = 1;
   */
  items: SIPTrunkInfo[];

  constructor(data?: PartialMessage<ListSIPTrunkResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ListSIPTrunkResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListSIPTrunkResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListSIPTrunkResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListSIPTrunkResponse;

  static equals(a: ListSIPTrunkResponse | PlainMessage<ListSIPTrunkResponse> | undefined, b: ListSIPTrunkResponse | PlainMessage<ListSIPTrunkResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.DeleteSIPTrunkRequest
 */
export declare class DeleteSIPTrunkRequest extends Message<DeleteSIPTrunkRequest> {
  /**
   * @generated from field: string sip_trunk_id = 1;
   */
  sipTrunkId: string;

  constructor(data?: PartialMessage<DeleteSIPTrunkRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.DeleteSIPTrunkRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DeleteSIPTrunkRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DeleteSIPTrunkRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DeleteSIPTrunkRequest;

  static equals(a: DeleteSIPTrunkRequest | PlainMessage<DeleteSIPTrunkRequest> | undefined, b: DeleteSIPTrunkRequest | PlainMessage<DeleteSIPTrunkRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.SIPDispatchRuleDirect
 */
export declare class SIPDispatchRuleDirect extends Message<SIPDispatchRuleDirect> {
  /**
   * What room should call be directed into
   *
   * @generated from field: string room_name = 1;
   */
  roomName: string;

  /**
   * Optional pin required to enter room
   *
   * @generated from field: string pin = 2;
   */
  pin: string;

  constructor(data?: PartialMessage<SIPDispatchRuleDirect>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.SIPDispatchRuleDirect";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SIPDispatchRuleDirect;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SIPDispatchRuleDirect;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SIPDispatchRuleDirect;

  static equals(a: SIPDispatchRuleDirect | PlainMessage<SIPDispatchRuleDirect> | undefined, b: SIPDispatchRuleDirect | PlainMessage<SIPDispatchRuleDirect> | undefined): boolean;
}

/**
 * @generated from message livekit.SIPDispatchRuleIndividual
 */
export declare class SIPDispatchRuleIndividual extends Message<SIPDispatchRuleIndividual> {
  /**
   * Prefix used on new room name
   *
   * @generated from field: string room_prefix = 1;
   */
  roomPrefix: string;

  /**
   * Optional pin required to enter room
   *
   * @generated from field: string pin = 2;
   */
  pin: string;

  constructor(data?: PartialMessage<SIPDispatchRuleIndividual>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.SIPDispatchRuleIndividual";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SIPDispatchRuleIndividual;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SIPDispatchRuleIndividual;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SIPDispatchRuleIndividual;

  static equals(a: SIPDispatchRuleIndividual | PlainMessage<SIPDispatchRuleIndividual> | undefined, b: SIPDispatchRuleIndividual | PlainMessage<SIPDispatchRuleIndividual> | undefined): boolean;
}

/**
 * @generated from message livekit.SIPDispatchRule
 */
export declare class SIPDispatchRule extends Message<SIPDispatchRule> {
  /**
   * @generated from oneof livekit.SIPDispatchRule.rule
   */
  rule: {
    /**
     * SIPDispatchRuleDirect is a `SIP Dispatch Rule` that puts a user directly into a room
     * This places users into an existing room. Optionally you can require a pin before a user can
     * enter the room
     *
     * @generated from field: livekit.SIPDispatchRuleDirect dispatch_rule_direct = 1;
     */
    value: SIPDispatchRuleDirect;
    case: "dispatchRuleDirect";
  } | {
    /**
     * SIPDispatchRuleIndividual is a `SIP Dispatch Rule` that creates a new room for each caller.
     *
     * @generated from field: livekit.SIPDispatchRuleIndividual dispatch_rule_individual = 2;
     */
    value: SIPDispatchRuleIndividual;
    case: "dispatchRuleIndividual";
  } | { case: undefined; value?: undefined };

  constructor(data?: PartialMessage<SIPDispatchRule>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.SIPDispatchRule";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SIPDispatchRule;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SIPDispatchRule;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SIPDispatchRule;

  static equals(a: SIPDispatchRule | PlainMessage<SIPDispatchRule> | undefined, b: SIPDispatchRule | PlainMessage<SIPDispatchRule> | undefined): boolean;
}

/**
 * @generated from message livekit.CreateSIPDispatchRuleRequest
 */
export declare class CreateSIPDispatchRuleRequest extends Message<CreateSIPDispatchRuleRequest> {
  /**
   * @generated from field: livekit.SIPDispatchRule rule = 1;
   */
  rule?: SIPDispatchRule;

  /**
   * What trunks are accepted for this dispatch rule
   * If empty all trunks will match this dispatch rule
   *
   * @generated from field: repeated string trunk_ids = 2;
   */
  trunkIds: string[];

  /**
   * By default the From value (Phone number) is used as the participant identity
   * If true a random value will be used instead
   *
   * @generated from field: bool hide_phone_number = 3;
   */
  hidePhoneNumber: boolean;

  constructor(data?: PartialMessage<CreateSIPDispatchRuleRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.CreateSIPDispatchRuleRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateSIPDispatchRuleRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateSIPDispatchRuleRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateSIPDispatchRuleRequest;

  static equals(a: CreateSIPDispatchRuleRequest | PlainMessage<CreateSIPDispatchRuleRequest> | undefined, b: CreateSIPDispatchRuleRequest | PlainMessage<CreateSIPDispatchRuleRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.SIPDispatchRuleInfo
 */
export declare class SIPDispatchRuleInfo extends Message<SIPDispatchRuleInfo> {
  /**
   * @generated from field: string sip_dispatch_rule_id = 1;
   */
  sipDispatchRuleId: string;

  /**
   * @generated from field: livekit.SIPDispatchRule rule = 2;
   */
  rule?: SIPDispatchRule;

  /**
   * @generated from field: repeated string trunk_ids = 3;
   */
  trunkIds: string[];

  /**
   * @generated from field: bool hide_phone_number = 4;
   */
  hidePhoneNumber: boolean;

  constructor(data?: PartialMessage<SIPDispatchRuleInfo>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.SIPDispatchRuleInfo";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SIPDispatchRuleInfo;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SIPDispatchRuleInfo;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SIPDispatchRuleInfo;

  static equals(a: SIPDispatchRuleInfo | PlainMessage<SIPDispatchRuleInfo> | undefined, b: SIPDispatchRuleInfo | PlainMessage<SIPDispatchRuleInfo> | undefined): boolean;
}

/**
 * @generated from message livekit.ListSIPDispatchRuleRequest
 */
export declare class ListSIPDispatchRuleRequest extends Message<ListSIPDispatchRuleRequest> {
  constructor(data?: PartialMessage<ListSIPDispatchRuleRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ListSIPDispatchRuleRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListSIPDispatchRuleRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListSIPDispatchRuleRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListSIPDispatchRuleRequest;

  static equals(a: ListSIPDispatchRuleRequest | PlainMessage<ListSIPDispatchRuleRequest> | undefined, b: ListSIPDispatchRuleRequest | PlainMessage<ListSIPDispatchRuleRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.ListSIPDispatchRuleResponse
 */
export declare class ListSIPDispatchRuleResponse extends Message<ListSIPDispatchRuleResponse> {
  /**
   * @generated from field: repeated livekit.SIPDispatchRuleInfo items = 1;
   */
  items: SIPDispatchRuleInfo[];

  constructor(data?: PartialMessage<ListSIPDispatchRuleResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ListSIPDispatchRuleResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListSIPDispatchRuleResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListSIPDispatchRuleResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListSIPDispatchRuleResponse;

  static equals(a: ListSIPDispatchRuleResponse | PlainMessage<ListSIPDispatchRuleResponse> | undefined, b: ListSIPDispatchRuleResponse | PlainMessage<ListSIPDispatchRuleResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.DeleteSIPDispatchRuleRequest
 */
export declare class DeleteSIPDispatchRuleRequest extends Message<DeleteSIPDispatchRuleRequest> {
  /**
   * @generated from field: string sip_dispatch_rule_id = 1;
   */
  sipDispatchRuleId: string;

  constructor(data?: PartialMessage<DeleteSIPDispatchRuleRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.DeleteSIPDispatchRuleRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DeleteSIPDispatchRuleRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DeleteSIPDispatchRuleRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DeleteSIPDispatchRuleRequest;

  static equals(a: DeleteSIPDispatchRuleRequest | PlainMessage<DeleteSIPDispatchRuleRequest> | undefined, b: DeleteSIPDispatchRuleRequest | PlainMessage<DeleteSIPDispatchRuleRequest> | undefined): boolean;
}

/**
 * A SIP Participant is a singular SIP session connected to a LiveKit room via
 * a SIP Trunk into a SIP DispatchRule
 *
 * @generated from message livekit.CreateSIPParticipantRequest
 */
export declare class CreateSIPParticipantRequest extends Message<CreateSIPParticipantRequest> {
  /**
   * What SIP Trunk should be used to dial the user
   *
   * @generated from field: string sip_trunk_id = 1;
   */
  sipTrunkId: string;

  /**
   * What number should be dialed via SIP
   *
   * @generated from field: string sip_call_to = 2;
   */
  sipCallTo: string;

  /**
   * What LiveKit room should this participant be connected too
   *
   * @generated from field: string room_name = 3;
   */
  roomName: string;

  /**
   * Optional identity of the participant in LiveKit room
   *
   * @generated from field: string participant_identity = 4;
   */
  participantIdentity: string;

  constructor(data?: PartialMessage<CreateSIPParticipantRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.CreateSIPParticipantRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateSIPParticipantRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateSIPParticipantRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateSIPParticipantRequest;

  static equals(a: CreateSIPParticipantRequest | PlainMessage<CreateSIPParticipantRequest> | undefined, b: CreateSIPParticipantRequest | PlainMessage<CreateSIPParticipantRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.SIPParticipantInfo
 */
export declare class SIPParticipantInfo extends Message<SIPParticipantInfo> {
  /**
   * @generated from field: string participant_id = 1;
   */
  participantId: string;

  /**
   * @generated from field: string participant_identity = 2;
   */
  participantIdentity: string;

  /**
   * @generated from field: string room_name = 3;
   */
  roomName: string;

  constructor(data?: PartialMessage<SIPParticipantInfo>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.SIPParticipantInfo";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SIPParticipantInfo;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SIPParticipantInfo;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SIPParticipantInfo;

  static equals(a: SIPParticipantInfo | PlainMessage<SIPParticipantInfo> | undefined, b: SIPParticipantInfo | PlainMessage<SIPParticipantInfo> | undefined): boolean;
}

