// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The location of the most recent parallel data input file that was successfully imported into Amazon Translate.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ParallelDataDataLocation {
    /// <p>Describes the repository that contains the parallel data input file.</p>
    pub repository_type: ::std::string::String,
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a presigned URL to that has a 30-minute expiration.</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub location: ::std::string::String,
}
impl ParallelDataDataLocation {
    /// <p>Describes the repository that contains the parallel data input file.</p>
    pub fn repository_type(&self) -> &str {
        use std::ops::Deref;
        self.repository_type.deref()
    }
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a presigned URL to that has a 30-minute expiration.</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn location(&self) -> &str {
        use std::ops::Deref;
        self.location.deref()
    }
}
impl ParallelDataDataLocation {
    /// Creates a new builder-style object to manufacture [`ParallelDataDataLocation`](crate::types::ParallelDataDataLocation).
    pub fn builder() -> crate::types::builders::ParallelDataDataLocationBuilder {
        crate::types::builders::ParallelDataDataLocationBuilder::default()
    }
}

/// A builder for [`ParallelDataDataLocation`](crate::types::ParallelDataDataLocation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ParallelDataDataLocationBuilder {
    pub(crate) repository_type: ::std::option::Option<::std::string::String>,
    pub(crate) location: ::std::option::Option<::std::string::String>,
}
impl ParallelDataDataLocationBuilder {
    /// <p>Describes the repository that contains the parallel data input file.</p>
    /// This field is required.
    pub fn repository_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.repository_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Describes the repository that contains the parallel data input file.</p>
    pub fn set_repository_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.repository_type = input;
        self
    }
    /// <p>Describes the repository that contains the parallel data input file.</p>
    pub fn get_repository_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.repository_type
    }
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a presigned URL to that has a 30-minute expiration.</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    /// This field is required.
    pub fn location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.location = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a presigned URL to that has a 30-minute expiration.</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn set_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.location = input;
        self
    }
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a presigned URL to that has a 30-minute expiration.</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn get_location(&self) -> &::std::option::Option<::std::string::String> {
        &self.location
    }
    /// Consumes the builder and constructs a [`ParallelDataDataLocation`](crate::types::ParallelDataDataLocation).
    /// This method will fail if any of the following fields are not set:
    /// - [`repository_type`](crate::types::builders::ParallelDataDataLocationBuilder::repository_type)
    /// - [`location`](crate::types::builders::ParallelDataDataLocationBuilder::location)
    pub fn build(self) -> ::std::result::Result<crate::types::ParallelDataDataLocation, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ParallelDataDataLocation {
            repository_type: self.repository_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "repository_type",
                    "repository_type was not specified but it is required when building ParallelDataDataLocation",
                )
            })?,
            location: self.location.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "location",
                    "location was not specified but it is required when building ParallelDataDataLocation",
                )
            })?,
        })
    }
}
