// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Allows you to specify additional settings for your Call Analytics post-call request, including output locations for your redacted transcript, which IAM role to use, and which encryption key to use.</p>
/// <p><code>DataAccessRoleArn</code> and <code>OutputLocation</code> are required fields.</p>
/// <p><code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics post-call transcription. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics</a> for more information on this feature.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct PostCallAnalyticsSettings {
    /// <p>The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use any of the following formats to specify the output location:</p>
    /// <ol>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json</p></li>
    /// </ol>
    pub output_location: ::std::string::String,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>
    pub data_access_role_arn: ::std::string::String,
    /// <p>Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you specify.</p>
    /// <p>Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (<code>ContentRedactionType</code>).</p>
    pub content_redaction_output: ::std::option::Option<crate::types::ContentRedactionOutput>,
    /// <p>The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
    /// <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p></li>
    /// <li>
    /// <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>Note that the role making the request must have permission to use the specified KMS key.</p>
    pub output_encryption_kms_key_id: ::std::option::Option<::std::string::String>,
}
impl PostCallAnalyticsSettings {
    /// <p>The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use any of the following formats to specify the output location:</p>
    /// <ol>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json</p></li>
    /// </ol>
    pub fn output_location(&self) -> &str {
        use std::ops::Deref;
        self.output_location.deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>
    pub fn data_access_role_arn(&self) -> &str {
        use std::ops::Deref;
        self.data_access_role_arn.deref()
    }
    /// <p>Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you specify.</p>
    /// <p>Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (<code>ContentRedactionType</code>).</p>
    pub fn content_redaction_output(&self) -> ::std::option::Option<&crate::types::ContentRedactionOutput> {
        self.content_redaction_output.as_ref()
    }
    /// <p>The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
    /// <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p></li>
    /// <li>
    /// <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>Note that the role making the request must have permission to use the specified KMS key.</p>
    pub fn output_encryption_kms_key_id(&self) -> ::std::option::Option<&str> {
        self.output_encryption_kms_key_id.as_deref()
    }
}
impl PostCallAnalyticsSettings {
    /// Creates a new builder-style object to manufacture [`PostCallAnalyticsSettings`](crate::types::PostCallAnalyticsSettings).
    pub fn builder() -> crate::types::builders::PostCallAnalyticsSettingsBuilder {
        crate::types::builders::PostCallAnalyticsSettingsBuilder::default()
    }
}

/// A builder for [`PostCallAnalyticsSettings`](crate::types::PostCallAnalyticsSettings).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PostCallAnalyticsSettingsBuilder {
    pub(crate) output_location: ::std::option::Option<::std::string::String>,
    pub(crate) data_access_role_arn: ::std::option::Option<::std::string::String>,
    pub(crate) content_redaction_output: ::std::option::Option<crate::types::ContentRedactionOutput>,
    pub(crate) output_encryption_kms_key_id: ::std::option::Option<::std::string::String>,
}
impl PostCallAnalyticsSettingsBuilder {
    /// <p>The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use any of the following formats to specify the output location:</p>
    /// <ol>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json</p></li>
    /// </ol>
    /// This field is required.
    pub fn output_location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.output_location = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use any of the following formats to specify the output location:</p>
    /// <ol>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json</p></li>
    /// </ol>
    pub fn set_output_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.output_location = input;
        self
    }
    /// <p>The Amazon S3 location where you want your Call Analytics post-call transcription output stored. You can use any of the following formats to specify the output location:</p>
    /// <ol>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/</p></li>
    /// <li>
    /// <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json</p></li>
    /// </ol>
    pub fn get_output_location(&self) -> &::std::option::Option<::std::string::String> {
        &self.output_location
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>
    /// This field is required.
    pub fn data_access_role_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.data_access_role_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>
    pub fn set_data_access_role_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.data_access_role_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p>
    /// <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>
    pub fn get_data_access_role_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.data_access_role_arn
    }
    /// <p>Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you specify.</p>
    /// <p>Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (<code>ContentRedactionType</code>).</p>
    pub fn content_redaction_output(mut self, input: crate::types::ContentRedactionOutput) -> Self {
        self.content_redaction_output = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you specify.</p>
    /// <p>Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (<code>ContentRedactionType</code>).</p>
    pub fn set_content_redaction_output(mut self, input: ::std::option::Option<crate::types::ContentRedactionOutput>) -> Self {
        self.content_redaction_output = input;
        self
    }
    /// <p>Specify whether you want only a redacted transcript or both a redacted and an unredacted transcript. If you choose redacted and unredacted, two JSON files are generated and stored in the Amazon S3 output location you specify.</p>
    /// <p>Note that to include <code>ContentRedactionOutput</code> in your request, you must enable content redaction (<code>ContentRedactionType</code>).</p>
    pub fn get_content_redaction_output(&self) -> &::std::option::Option<crate::types::ContentRedactionOutput> {
        &self.content_redaction_output
    }
    /// <p>The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
    /// <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p></li>
    /// <li>
    /// <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>Note that the role making the request must have permission to use the specified KMS key.</p>
    pub fn output_encryption_kms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.output_encryption_kms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
    /// <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p></li>
    /// <li>
    /// <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>Note that the role making the request must have permission to use the specified KMS key.</p>
    pub fn set_output_encryption_kms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.output_encryption_kms_key_id = input;
        self
    }
    /// <p>The KMS key you want to use to encrypt your Call Analytics post-call output.</p>
    /// <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p></li>
    /// <li>
    /// <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p>
    /// <ol>
    /// <li>
    /// <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p></li>
    /// <li>
    /// <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p></li>
    /// </ol>
    /// <p>Note that the role making the request must have permission to use the specified KMS key.</p>
    pub fn get_output_encryption_kms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.output_encryption_kms_key_id
    }
    /// Consumes the builder and constructs a [`PostCallAnalyticsSettings`](crate::types::PostCallAnalyticsSettings).
    /// This method will fail if any of the following fields are not set:
    /// - [`output_location`](crate::types::builders::PostCallAnalyticsSettingsBuilder::output_location)
    /// - [`data_access_role_arn`](crate::types::builders::PostCallAnalyticsSettingsBuilder::data_access_role_arn)
    pub fn build(self) -> ::std::result::Result<crate::types::PostCallAnalyticsSettings, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::PostCallAnalyticsSettings {
            output_location: self.output_location.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "output_location",
                    "output_location was not specified but it is required when building PostCallAnalyticsSettings",
                )
            })?,
            data_access_role_arn: self.data_access_role_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "data_access_role_arn",
                    "data_access_role_arn was not specified but it is required when building PostCallAnalyticsSettings",
                )
            })?,
            content_redaction_output: self.content_redaction_output,
            output_encryption_kms_key_id: self.output_encryption_kms_key_id,
        })
    }
}
