// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The <code>MedicalTranscriptEvent</code> associated with a <code>MedicalTranscriptResultStream</code>.</p>
/// <p>Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalTranscriptEvent {
    /// <p>Contains <code>Results</code>, which contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub transcript: ::std::option::Option<crate::types::MedicalTranscript>,
}
impl MedicalTranscriptEvent {
    /// <p>Contains <code>Results</code>, which contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn transcript(&self) -> ::std::option::Option<&crate::types::MedicalTranscript> {
        self.transcript.as_ref()
    }
}
impl MedicalTranscriptEvent {
    /// Creates a new builder-style object to manufacture [`MedicalTranscriptEvent`](crate::types::MedicalTranscriptEvent).
    pub fn builder() -> crate::types::builders::MedicalTranscriptEventBuilder {
        crate::types::builders::MedicalTranscriptEventBuilder::default()
    }
}

/// A builder for [`MedicalTranscriptEvent`](crate::types::MedicalTranscriptEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalTranscriptEventBuilder {
    pub(crate) transcript: ::std::option::Option<crate::types::MedicalTranscript>,
}
impl MedicalTranscriptEventBuilder {
    /// <p>Contains <code>Results</code>, which contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn transcript(mut self, input: crate::types::MedicalTranscript) -> Self {
        self.transcript = ::std::option::Option::Some(input);
        self
    }
    /// <p>Contains <code>Results</code>, which contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn set_transcript(mut self, input: ::std::option::Option<crate::types::MedicalTranscript>) -> Self {
        self.transcript = input;
        self
    }
    /// <p>Contains <code>Results</code>, which contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.</p>
    pub fn get_transcript(&self) -> &::std::option::Option<crate::types::MedicalTranscript> {
        &self.transcript
    }
    /// Consumes the builder and constructs a [`MedicalTranscriptEvent`](crate::types::MedicalTranscriptEvent).
    pub fn build(self) -> crate::types::MedicalTranscriptEvent {
        crate::types::MedicalTranscriptEvent { transcript: self.transcript }
    }
}
