// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A word, phrase, or punctuation mark in your transcription output, along with various associated attributes, such as confidence score, type, and start and end times.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalScribeTranscriptItem {
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub begin_audio_time: f64,
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub end_audio_time: f64,
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub r#type: ::std::option::Option<crate::types::MedicalScribeTranscriptItemType>,
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub confidence: ::std::option::Option<f64>,
    /// <p>The word, phrase or punctuation mark that was transcribed.</p>
    pub content: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your configuration event. If <code>true</code>, there is a vocabulary filter match.</p>
    pub vocabulary_filter_match: ::std::option::Option<bool>,
}
impl MedicalScribeTranscriptItem {
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn begin_audio_time(&self) -> f64 {
        self.begin_audio_time
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn end_audio_time(&self) -> f64 {
        self.end_audio_time
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn r#type(&self) -> ::std::option::Option<&crate::types::MedicalScribeTranscriptItemType> {
        self.r#type.as_ref()
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn confidence(&self) -> ::std::option::Option<f64> {
        self.confidence
    }
    /// <p>The word, phrase or punctuation mark that was transcribed.</p>
    pub fn content(&self) -> ::std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your configuration event. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn vocabulary_filter_match(&self) -> ::std::option::Option<bool> {
        self.vocabulary_filter_match
    }
}
impl MedicalScribeTranscriptItem {
    /// Creates a new builder-style object to manufacture [`MedicalScribeTranscriptItem`](crate::types::MedicalScribeTranscriptItem).
    pub fn builder() -> crate::types::builders::MedicalScribeTranscriptItemBuilder {
        crate::types::builders::MedicalScribeTranscriptItemBuilder::default()
    }
}

/// A builder for [`MedicalScribeTranscriptItem`](crate::types::MedicalScribeTranscriptItem).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalScribeTranscriptItemBuilder {
    pub(crate) begin_audio_time: ::std::option::Option<f64>,
    pub(crate) end_audio_time: ::std::option::Option<f64>,
    pub(crate) r#type: ::std::option::Option<crate::types::MedicalScribeTranscriptItemType>,
    pub(crate) confidence: ::std::option::Option<f64>,
    pub(crate) content: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_match: ::std::option::Option<bool>,
}
impl MedicalScribeTranscriptItemBuilder {
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn begin_audio_time(mut self, input: f64) -> Self {
        self.begin_audio_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn set_begin_audio_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.begin_audio_time = input;
        self
    }
    /// <p>The start time, in milliseconds, of the transcribed item.</p>
    pub fn get_begin_audio_time(&self) -> &::std::option::Option<f64> {
        &self.begin_audio_time
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn end_audio_time(mut self, input: f64) -> Self {
        self.end_audio_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn set_end_audio_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.end_audio_time = input;
        self
    }
    /// <p>The end time, in milliseconds, of the transcribed item.</p>
    pub fn get_end_audio_time(&self) -> &::std::option::Option<f64> {
        &self.end_audio_time
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn r#type(mut self, input: crate::types::MedicalScribeTranscriptItemType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::MedicalScribeTranscriptItemType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::MedicalScribeTranscriptItemType> {
        &self.r#type
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn confidence(mut self, input: f64) -> Self {
        self.confidence = ::std::option::Option::Some(input);
        self
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn set_confidence(mut self, input: ::std::option::Option<f64>) -> Self {
        self.confidence = input;
        self
    }
    /// <p>The confidence score associated with a word or phrase in your transcript.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.</p>
    pub fn get_confidence(&self) -> &::std::option::Option<f64> {
        &self.confidence
    }
    /// <p>The word, phrase or punctuation mark that was transcribed.</p>
    pub fn content(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The word, phrase or punctuation mark that was transcribed.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content = input;
        self
    }
    /// <p>The word, phrase or punctuation mark that was transcribed.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::string::String> {
        &self.content
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your configuration event. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn vocabulary_filter_match(mut self, input: bool) -> Self {
        self.vocabulary_filter_match = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your configuration event. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn set_vocabulary_filter_match(mut self, input: ::std::option::Option<bool>) -> Self {
        self.vocabulary_filter_match = input;
        self
    }
    /// <p>Indicates whether the specified item matches a word in the vocabulary filter included in your configuration event. If <code>true</code>, there is a vocabulary filter match.</p>
    pub fn get_vocabulary_filter_match(&self) -> &::std::option::Option<bool> {
        &self.vocabulary_filter_match
    }
    /// Consumes the builder and constructs a [`MedicalScribeTranscriptItem`](crate::types::MedicalScribeTranscriptItem).
    pub fn build(self) -> crate::types::MedicalScribeTranscriptItem {
        crate::types::MedicalScribeTranscriptItem {
            begin_audio_time: self.begin_audio_time.unwrap_or_default(),
            end_audio_time: self.end_audio_time.unwrap_or_default(),
            r#type: self.r#type,
            confidence: self.confidence,
            content: self.content,
            vocabulary_filter_match: self.vocabulary_filter_match,
        }
    }
}
