// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains detailed information about your real-time Call Analytics session. These details are provided in the <code>UtteranceEvent</code> and <code>CategoryEvent</code> objects.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum CallAnalyticsTranscriptResultStream {
    /// <p>Provides information on matched categories that were used to generate real-time supervisor alerts.</p>
    CategoryEvent(crate::types::CategoryEvent),
    /// <p>Contains set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to channel definitions, partial result stabilization, sentiment, issue detection, and other transcription-related data.</p>
    UtteranceEvent(crate::types::UtteranceEvent),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl CallAnalyticsTranscriptResultStream {
    /// Tries to convert the enum instance into [`CategoryEvent`](crate::types::CallAnalyticsTranscriptResultStream::CategoryEvent), extracting the inner [`CategoryEvent`](crate::types::CategoryEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_category_event(&self) -> ::std::result::Result<&crate::types::CategoryEvent, &Self> {
        if let CallAnalyticsTranscriptResultStream::CategoryEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`CategoryEvent`](crate::types::CallAnalyticsTranscriptResultStream::CategoryEvent).
    pub fn is_category_event(&self) -> bool {
        self.as_category_event().is_ok()
    }
    /// Tries to convert the enum instance into [`UtteranceEvent`](crate::types::CallAnalyticsTranscriptResultStream::UtteranceEvent), extracting the inner [`UtteranceEvent`](crate::types::UtteranceEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_utterance_event(&self) -> ::std::result::Result<&crate::types::UtteranceEvent, &Self> {
        if let CallAnalyticsTranscriptResultStream::UtteranceEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`UtteranceEvent`](crate::types::CallAnalyticsTranscriptResultStream::UtteranceEvent).
    pub fn is_utterance_event(&self) -> bool {
        self.as_utterance_event().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
