// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A wrapper for your audio chunks. Your audio stream consists of one or more audio events, which consist of one or more audio chunks.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream encoding</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AudioEvent {
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub audio_chunk: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl AudioEvent {
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn audio_chunk(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.audio_chunk.as_ref()
    }
}
impl AudioEvent {
    /// Creates a new builder-style object to manufacture [`AudioEvent`](crate::types::AudioEvent).
    pub fn builder() -> crate::types::builders::AudioEventBuilder {
        crate::types::builders::AudioEventBuilder::default()
    }
}

/// A builder for [`AudioEvent`](crate::types::AudioEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct AudioEventBuilder {
    pub(crate) audio_chunk: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl AudioEventBuilder {
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn audio_chunk(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.audio_chunk = ::std::option::Option::Some(input);
        self
    }
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn set_audio_chunk(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.audio_chunk = input;
        self
    }
    /// <p>An audio blob containing the next segment of audio from your application, with a maximum duration of 1 second. The maximum size in bytes varies based on audio properties.</p>
    /// <p>Find recommended size in <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#best-practices">Transcribing streaming best practices</a>.</p>
    /// <p>Size calculation: <code>Duration (s) * Sample Rate (Hz) * Number of Channels * 2 (Bytes per Sample)</code></p>
    /// <p>For example, a 1-second chunk of 16 kHz, 2-channel, 16-bit audio would be <code>1 * 16000 * 2 * 2 = 64000 bytes</code>.</p>
    /// <p>For 8 kHz, 1-channel, 16-bit audio, a 1-second chunk would be <code>1 * 8000 * 1 * 2 = 16000 bytes</code>.</p>
    pub fn get_audio_chunk(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.audio_chunk
    }
    /// Consumes the builder and constructs a [`AudioEvent`](crate::types::AudioEvent).
    pub fn build(self) -> crate::types::AudioEvent {
        crate::types::AudioEvent {
            audio_chunk: self.audio_chunk,
        }
    }
}
