// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub struct StartStreamTranscriptionOutput {
    /// <p>Provides the identifier for your streaming request.</p>
    pub request_id: ::std::option::Option<::std::string::String>,
    /// <p>Provides the language code that you specified in your request.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub media_sample_rate_hertz: ::std::option::Option<i32>,
    /// <p>Provides the media encoding you specified in your request.</p>
    pub media_encoding: ::std::option::Option<crate::types::MediaEncoding>,
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub vocabulary_name: ::std::option::Option<::std::string::String>,
    /// <p>Provides the identifier for your transcription session.</p>
    pub session_id: ::std::option::Option<::std::string::String>,
    /// <p>Provides detailed information about your streaming session.</p>
    pub transcript_result_stream:
        crate::event_receiver::EventReceiver<crate::types::TranscriptResultStream, crate::types::error::TranscriptResultStreamError>,
    /// <p>Provides the name of the custom vocabulary filter that you specified in your request.</p>
    pub vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    /// <p>Provides the vocabulary filtering method used in your transcription.</p>
    pub vocabulary_filter_method: ::std::option::Option<crate::types::VocabularyFilterMethod>,
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub show_speaker_label: bool,
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub enable_channel_identification: bool,
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub number_of_channels: ::std::option::Option<i32>,
    /// <p>Shows whether partial results stabilization was enabled for your transcription.</p>
    pub enable_partial_results_stabilization: bool,
    /// <p>Provides the stabilization level used for your transcription.</p>
    pub partial_results_stability: ::std::option::Option<crate::types::PartialResultsStability>,
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub content_identification_type: ::std::option::Option<crate::types::ContentIdentificationType>,
    /// <p>Shows whether content redaction was enabled for your transcription.</p>
    pub content_redaction_type: ::std::option::Option<crate::types::ContentRedactionType>,
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub pii_entity_types: ::std::option::Option<::std::string::String>,
    /// <p>Provides the name of the custom language model that you specified in your request.</p>
    pub language_model_name: ::std::option::Option<::std::string::String>,
    /// <p>Shows whether automatic language identification was enabled for your transcription.</p>
    pub identify_language: bool,
    /// <p>Provides the language codes that you specified in your request.</p>
    pub language_options: ::std::option::Option<::std::string::String>,
    /// <p>Provides the preferred language that you specified in your request.</p>
    pub preferred_language: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>Shows whether automatic multi-language identification was enabled for your transcription.</p>
    pub identify_multiple_languages: bool,
    /// <p>Provides the names of the custom vocabularies that you specified in your request.</p>
    pub vocabulary_names: ::std::option::Option<::std::string::String>,
    /// <p>Provides the names of the custom vocabulary filters that you specified in your request.</p>
    pub vocabulary_filter_names: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl StartStreamTranscriptionOutput {
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn request_id(&self) -> ::std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>Provides the language code that you specified in your request.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn media_sample_rate_hertz(&self) -> ::std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn media_encoding(&self) -> ::std::option::Option<&crate::types::MediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn vocabulary_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn session_id(&self) -> ::std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn transcript_result_stream(
        &self,
    ) -> &crate::event_receiver::EventReceiver<crate::types::TranscriptResultStream, crate::types::error::TranscriptResultStreamError> {
        &self.transcript_result_stream
    }
    /// <p>Provides the name of the custom vocabulary filter that you specified in your request.</p>
    pub fn vocabulary_filter_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>Provides the vocabulary filtering method used in your transcription.</p>
    pub fn vocabulary_filter_method(&self) -> ::std::option::Option<&crate::types::VocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn show_speaker_label(&self) -> bool {
        self.show_speaker_label
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn enable_channel_identification(&self) -> bool {
        self.enable_channel_identification
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn number_of_channels(&self) -> ::std::option::Option<i32> {
        self.number_of_channels
    }
    /// <p>Shows whether partial results stabilization was enabled for your transcription.</p>
    pub fn enable_partial_results_stabilization(&self) -> bool {
        self.enable_partial_results_stabilization
    }
    /// <p>Provides the stabilization level used for your transcription.</p>
    pub fn partial_results_stability(&self) -> ::std::option::Option<&crate::types::PartialResultsStability> {
        self.partial_results_stability.as_ref()
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn content_identification_type(&self) -> ::std::option::Option<&crate::types::ContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
    /// <p>Shows whether content redaction was enabled for your transcription.</p>
    pub fn content_redaction_type(&self) -> ::std::option::Option<&crate::types::ContentRedactionType> {
        self.content_redaction_type.as_ref()
    }
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub fn pii_entity_types(&self) -> ::std::option::Option<&str> {
        self.pii_entity_types.as_deref()
    }
    /// <p>Provides the name of the custom language model that you specified in your request.</p>
    pub fn language_model_name(&self) -> ::std::option::Option<&str> {
        self.language_model_name.as_deref()
    }
    /// <p>Shows whether automatic language identification was enabled for your transcription.</p>
    pub fn identify_language(&self) -> bool {
        self.identify_language
    }
    /// <p>Provides the language codes that you specified in your request.</p>
    pub fn language_options(&self) -> ::std::option::Option<&str> {
        self.language_options.as_deref()
    }
    /// <p>Provides the preferred language that you specified in your request.</p>
    pub fn preferred_language(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.preferred_language.as_ref()
    }
    /// <p>Shows whether automatic multi-language identification was enabled for your transcription.</p>
    pub fn identify_multiple_languages(&self) -> bool {
        self.identify_multiple_languages
    }
    /// <p>Provides the names of the custom vocabularies that you specified in your request.</p>
    pub fn vocabulary_names(&self) -> ::std::option::Option<&str> {
        self.vocabulary_names.as_deref()
    }
    /// <p>Provides the names of the custom vocabulary filters that you specified in your request.</p>
    pub fn vocabulary_filter_names(&self) -> ::std::option::Option<&str> {
        self.vocabulary_filter_names.as_deref()
    }
}
impl ::aws_types::request_id::RequestId for StartStreamTranscriptionOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl StartStreamTranscriptionOutput {
    /// Creates a new builder-style object to manufacture [`StartStreamTranscriptionOutput`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput).
    pub fn builder() -> crate::operation::start_stream_transcription::builders::StartStreamTranscriptionOutputBuilder {
        crate::operation::start_stream_transcription::builders::StartStreamTranscriptionOutputBuilder::default()
    }
}

/// A builder for [`StartStreamTranscriptionOutput`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput).
#[derive(::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartStreamTranscriptionOutputBuilder {
    pub(crate) request_id: ::std::option::Option<::std::string::String>,
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) media_sample_rate_hertz: ::std::option::Option<i32>,
    pub(crate) media_encoding: ::std::option::Option<crate::types::MediaEncoding>,
    pub(crate) vocabulary_name: ::std::option::Option<::std::string::String>,
    pub(crate) session_id: ::std::option::Option<::std::string::String>,
    pub(crate) transcript_result_stream: ::std::option::Option<
        crate::event_receiver::EventReceiver<crate::types::TranscriptResultStream, crate::types::error::TranscriptResultStreamError>,
    >,
    pub(crate) vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_method: ::std::option::Option<crate::types::VocabularyFilterMethod>,
    pub(crate) show_speaker_label: ::std::option::Option<bool>,
    pub(crate) enable_channel_identification: ::std::option::Option<bool>,
    pub(crate) number_of_channels: ::std::option::Option<i32>,
    pub(crate) enable_partial_results_stabilization: ::std::option::Option<bool>,
    pub(crate) partial_results_stability: ::std::option::Option<crate::types::PartialResultsStability>,
    pub(crate) content_identification_type: ::std::option::Option<crate::types::ContentIdentificationType>,
    pub(crate) content_redaction_type: ::std::option::Option<crate::types::ContentRedactionType>,
    pub(crate) pii_entity_types: ::std::option::Option<::std::string::String>,
    pub(crate) language_model_name: ::std::option::Option<::std::string::String>,
    pub(crate) identify_language: ::std::option::Option<bool>,
    pub(crate) language_options: ::std::option::Option<::std::string::String>,
    pub(crate) preferred_language: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) identify_multiple_languages: ::std::option::Option<bool>,
    pub(crate) vocabulary_names: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_names: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl StartStreamTranscriptionOutputBuilder {
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn request_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.request_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn set_request_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.request_id = input;
        self
    }
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn get_request_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.request_id
    }
    /// <p>Provides the language code that you specified in your request.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the language code that you specified in your request.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Provides the language code that you specified in your request.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
        self.media_sample_rate_hertz = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn set_media_sample_rate_hertz(mut self, input: ::std::option::Option<i32>) -> Self {
        self.media_sample_rate_hertz = input;
        self
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn get_media_sample_rate_hertz(&self) -> &::std::option::Option<i32> {
        &self.media_sample_rate_hertz
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn media_encoding(mut self, input: crate::types::MediaEncoding) -> Self {
        self.media_encoding = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn set_media_encoding(mut self, input: ::std::option::Option<crate::types::MediaEncoding>) -> Self {
        self.media_encoding = input;
        self
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn get_media_encoding(&self) -> &::std::option::Option<crate::types::MediaEncoding> {
        &self.media_encoding
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn vocabulary_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn set_vocabulary_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_name = input;
        self
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn get_vocabulary_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_name
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn session_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn set_session_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_id = input;
        self
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn get_session_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_id
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn transcript_result_stream(
        mut self,
        input: crate::event_receiver::EventReceiver<crate::types::TranscriptResultStream, crate::types::error::TranscriptResultStreamError>,
    ) -> Self {
        self.transcript_result_stream = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn set_transcript_result_stream(
        mut self,
        input: ::std::option::Option<
            crate::event_receiver::EventReceiver<crate::types::TranscriptResultStream, crate::types::error::TranscriptResultStreamError>,
        >,
    ) -> Self {
        self.transcript_result_stream = input;
        self
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn get_transcript_result_stream(
        &self,
    ) -> &::std::option::Option<
        crate::event_receiver::EventReceiver<crate::types::TranscriptResultStream, crate::types::error::TranscriptResultStreamError>,
    > {
        &self.transcript_result_stream
    }
    /// <p>Provides the name of the custom vocabulary filter that you specified in your request.</p>
    pub fn vocabulary_filter_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_filter_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the name of the custom vocabulary filter that you specified in your request.</p>
    pub fn set_vocabulary_filter_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_filter_name = input;
        self
    }
    /// <p>Provides the name of the custom vocabulary filter that you specified in your request.</p>
    pub fn get_vocabulary_filter_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_filter_name
    }
    /// <p>Provides the vocabulary filtering method used in your transcription.</p>
    pub fn vocabulary_filter_method(mut self, input: crate::types::VocabularyFilterMethod) -> Self {
        self.vocabulary_filter_method = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the vocabulary filtering method used in your transcription.</p>
    pub fn set_vocabulary_filter_method(mut self, input: ::std::option::Option<crate::types::VocabularyFilterMethod>) -> Self {
        self.vocabulary_filter_method = input;
        self
    }
    /// <p>Provides the vocabulary filtering method used in your transcription.</p>
    pub fn get_vocabulary_filter_method(&self) -> &::std::option::Option<crate::types::VocabularyFilterMethod> {
        &self.vocabulary_filter_method
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn show_speaker_label(mut self, input: bool) -> Self {
        self.show_speaker_label = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn set_show_speaker_label(mut self, input: ::std::option::Option<bool>) -> Self {
        self.show_speaker_label = input;
        self
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn get_show_speaker_label(&self) -> &::std::option::Option<bool> {
        &self.show_speaker_label
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn enable_channel_identification(mut self, input: bool) -> Self {
        self.enable_channel_identification = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn set_enable_channel_identification(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enable_channel_identification = input;
        self
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn get_enable_channel_identification(&self) -> &::std::option::Option<bool> {
        &self.enable_channel_identification
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn number_of_channels(mut self, input: i32) -> Self {
        self.number_of_channels = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn set_number_of_channels(mut self, input: ::std::option::Option<i32>) -> Self {
        self.number_of_channels = input;
        self
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn get_number_of_channels(&self) -> &::std::option::Option<i32> {
        &self.number_of_channels
    }
    /// <p>Shows whether partial results stabilization was enabled for your transcription.</p>
    pub fn enable_partial_results_stabilization(mut self, input: bool) -> Self {
        self.enable_partial_results_stabilization = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether partial results stabilization was enabled for your transcription.</p>
    pub fn set_enable_partial_results_stabilization(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enable_partial_results_stabilization = input;
        self
    }
    /// <p>Shows whether partial results stabilization was enabled for your transcription.</p>
    pub fn get_enable_partial_results_stabilization(&self) -> &::std::option::Option<bool> {
        &self.enable_partial_results_stabilization
    }
    /// <p>Provides the stabilization level used for your transcription.</p>
    pub fn partial_results_stability(mut self, input: crate::types::PartialResultsStability) -> Self {
        self.partial_results_stability = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the stabilization level used for your transcription.</p>
    pub fn set_partial_results_stability(mut self, input: ::std::option::Option<crate::types::PartialResultsStability>) -> Self {
        self.partial_results_stability = input;
        self
    }
    /// <p>Provides the stabilization level used for your transcription.</p>
    pub fn get_partial_results_stability(&self) -> &::std::option::Option<crate::types::PartialResultsStability> {
        &self.partial_results_stability
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn content_identification_type(mut self, input: crate::types::ContentIdentificationType) -> Self {
        self.content_identification_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn set_content_identification_type(mut self, input: ::std::option::Option<crate::types::ContentIdentificationType>) -> Self {
        self.content_identification_type = input;
        self
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn get_content_identification_type(&self) -> &::std::option::Option<crate::types::ContentIdentificationType> {
        &self.content_identification_type
    }
    /// <p>Shows whether content redaction was enabled for your transcription.</p>
    pub fn content_redaction_type(mut self, input: crate::types::ContentRedactionType) -> Self {
        self.content_redaction_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether content redaction was enabled for your transcription.</p>
    pub fn set_content_redaction_type(mut self, input: ::std::option::Option<crate::types::ContentRedactionType>) -> Self {
        self.content_redaction_type = input;
        self
    }
    /// <p>Shows whether content redaction was enabled for your transcription.</p>
    pub fn get_content_redaction_type(&self) -> &::std::option::Option<crate::types::ContentRedactionType> {
        &self.content_redaction_type
    }
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub fn pii_entity_types(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.pii_entity_types = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub fn set_pii_entity_types(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.pii_entity_types = input;
        self
    }
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub fn get_pii_entity_types(&self) -> &::std::option::Option<::std::string::String> {
        &self.pii_entity_types
    }
    /// <p>Provides the name of the custom language model that you specified in your request.</p>
    pub fn language_model_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_model_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the name of the custom language model that you specified in your request.</p>
    pub fn set_language_model_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_model_name = input;
        self
    }
    /// <p>Provides the name of the custom language model that you specified in your request.</p>
    pub fn get_language_model_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_model_name
    }
    /// <p>Shows whether automatic language identification was enabled for your transcription.</p>
    pub fn identify_language(mut self, input: bool) -> Self {
        self.identify_language = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether automatic language identification was enabled for your transcription.</p>
    pub fn set_identify_language(mut self, input: ::std::option::Option<bool>) -> Self {
        self.identify_language = input;
        self
    }
    /// <p>Shows whether automatic language identification was enabled for your transcription.</p>
    pub fn get_identify_language(&self) -> &::std::option::Option<bool> {
        &self.identify_language
    }
    /// <p>Provides the language codes that you specified in your request.</p>
    pub fn language_options(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_options = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the language codes that you specified in your request.</p>
    pub fn set_language_options(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_options = input;
        self
    }
    /// <p>Provides the language codes that you specified in your request.</p>
    pub fn get_language_options(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_options
    }
    /// <p>Provides the preferred language that you specified in your request.</p>
    pub fn preferred_language(mut self, input: crate::types::LanguageCode) -> Self {
        self.preferred_language = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the preferred language that you specified in your request.</p>
    pub fn set_preferred_language(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.preferred_language = input;
        self
    }
    /// <p>Provides the preferred language that you specified in your request.</p>
    pub fn get_preferred_language(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.preferred_language
    }
    /// <p>Shows whether automatic multi-language identification was enabled for your transcription.</p>
    pub fn identify_multiple_languages(mut self, input: bool) -> Self {
        self.identify_multiple_languages = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether automatic multi-language identification was enabled for your transcription.</p>
    pub fn set_identify_multiple_languages(mut self, input: ::std::option::Option<bool>) -> Self {
        self.identify_multiple_languages = input;
        self
    }
    /// <p>Shows whether automatic multi-language identification was enabled for your transcription.</p>
    pub fn get_identify_multiple_languages(&self) -> &::std::option::Option<bool> {
        &self.identify_multiple_languages
    }
    /// <p>Provides the names of the custom vocabularies that you specified in your request.</p>
    pub fn vocabulary_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_names = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the names of the custom vocabularies that you specified in your request.</p>
    pub fn set_vocabulary_names(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_names = input;
        self
    }
    /// <p>Provides the names of the custom vocabularies that you specified in your request.</p>
    pub fn get_vocabulary_names(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_names
    }
    /// <p>Provides the names of the custom vocabulary filters that you specified in your request.</p>
    pub fn vocabulary_filter_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_filter_names = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the names of the custom vocabulary filters that you specified in your request.</p>
    pub fn set_vocabulary_filter_names(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_filter_names = input;
        self
    }
    /// <p>Provides the names of the custom vocabulary filters that you specified in your request.</p>
    pub fn get_vocabulary_filter_names(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_filter_names
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`StartStreamTranscriptionOutput`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`transcript_result_stream`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionOutputBuilder::transcript_result_stream)
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_stream_transcription::StartStreamTranscriptionOutput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::start_stream_transcription::StartStreamTranscriptionOutput {
            request_id: self.request_id,
            language_code: self.language_code,
            media_sample_rate_hertz: self.media_sample_rate_hertz,
            media_encoding: self.media_encoding,
            vocabulary_name: self.vocabulary_name,
            session_id: self.session_id,
            transcript_result_stream: self.transcript_result_stream.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "transcript_result_stream",
                    "transcript_result_stream was not specified but it is required when building StartStreamTranscriptionOutput",
                )
            })?,
            vocabulary_filter_name: self.vocabulary_filter_name,
            vocabulary_filter_method: self.vocabulary_filter_method,
            show_speaker_label: self.show_speaker_label.unwrap_or_default(),
            enable_channel_identification: self.enable_channel_identification.unwrap_or_default(),
            number_of_channels: self.number_of_channels,
            enable_partial_results_stabilization: self.enable_partial_results_stabilization.unwrap_or_default(),
            partial_results_stability: self.partial_results_stability,
            content_identification_type: self.content_identification_type,
            content_redaction_type: self.content_redaction_type,
            pii_entity_types: self.pii_entity_types,
            language_model_name: self.language_model_name,
            identify_language: self.identify_language.unwrap_or_default(),
            language_options: self.language_options,
            preferred_language: self.preferred_language,
            identify_multiple_languages: self.identify_multiple_languages.unwrap_or_default(),
            vocabulary_names: self.vocabulary_names,
            vocabulary_filter_names: self.vocabulary_filter_names,
            _request_id: self._request_id,
        })
    }
}
