// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides lexicon name and lexicon content in string format. For more information, see <a href="https://www.w3.org/TR/pronunciation-lexicon/">Pronunciation Lexicon Specification (PLS) Version 1.0</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct Lexicon {
    /// <p>Lexicon content in string format. The content of a lexicon must be in PLS format.</p>
    pub content: ::std::option::Option<::std::string::String>,
    /// <p>Name of the lexicon.</p>
    pub name: ::std::option::Option<::std::string::String>,
}
impl Lexicon {
    /// <p>Lexicon content in string format. The content of a lexicon must be in PLS format.</p>
    pub fn content(&self) -> ::std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>Name of the lexicon.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl ::std::fmt::Debug for Lexicon {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("Lexicon");
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
impl Lexicon {
    /// Creates a new builder-style object to manufacture [`Lexicon`](crate::types::Lexicon).
    pub fn builder() -> crate::types::builders::LexiconBuilder {
        crate::types::builders::LexiconBuilder::default()
    }
}

/// A builder for [`Lexicon`](crate::types::Lexicon).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct LexiconBuilder {
    pub(crate) content: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
}
impl LexiconBuilder {
    /// <p>Lexicon content in string format. The content of a lexicon must be in PLS format.</p>
    pub fn content(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Lexicon content in string format. The content of a lexicon must be in PLS format.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content = input;
        self
    }
    /// <p>Lexicon content in string format. The content of a lexicon must be in PLS format.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::string::String> {
        &self.content
    }
    /// <p>Name of the lexicon.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Name of the lexicon.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>Name of the lexicon.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// Consumes the builder and constructs a [`Lexicon`](crate::types::Lexicon).
    pub fn build(self) -> crate::types::Lexicon {
        crate::types::Lexicon {
            content: self.content,
            name: self.name,
        }
    }
}
impl ::std::fmt::Debug for LexiconBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("LexiconBuilder");
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
