// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StartSpeechSynthesisTaskInput {
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub engine: ::std::option::Option<crate::types::Engine>,
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub lexicon_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub output_format: ::std::option::Option<crate::types::OutputFormat>,
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub output_s3_bucket_name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub output_s3_key_prefix: ::std::option::Option<::std::string::String>,
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub sample_rate: ::std::option::Option<::std::string::String>,
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub sns_topic_arn: ::std::option::Option<::std::string::String>,
    /// <p>The type of speech marks returned for the input text.</p>
    pub speech_mark_types: ::std::option::Option<::std::vec::Vec<crate::types::SpeechMarkType>>,
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub text: ::std::option::Option<::std::string::String>,
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub text_type: ::std::option::Option<crate::types::TextType>,
    /// <p>Voice ID to use for the synthesis.</p>
    pub voice_id: ::std::option::Option<crate::types::VoiceId>,
}
impl StartSpeechSynthesisTaskInput {
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn engine(&self) -> ::std::option::Option<&crate::types::Engine> {
        self.engine.as_ref()
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.lexicon_names.is_none()`.
    pub fn lexicon_names(&self) -> &[::std::string::String] {
        self.lexicon_names.as_deref().unwrap_or_default()
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub fn output_format(&self) -> ::std::option::Option<&crate::types::OutputFormat> {
        self.output_format.as_ref()
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub fn output_s3_bucket_name(&self) -> ::std::option::Option<&str> {
        self.output_s3_bucket_name.as_deref()
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn output_s3_key_prefix(&self) -> ::std::option::Option<&str> {
        self.output_s3_key_prefix.as_deref()
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn sample_rate(&self) -> ::std::option::Option<&str> {
        self.sample_rate.as_deref()
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn sns_topic_arn(&self) -> ::std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The type of speech marks returned for the input text.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.speech_mark_types.is_none()`.
    pub fn speech_mark_types(&self) -> &[crate::types::SpeechMarkType] {
        self.speech_mark_types.as_deref().unwrap_or_default()
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub fn text(&self) -> ::std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn text_type(&self) -> ::std::option::Option<&crate::types::TextType> {
        self.text_type.as_ref()
    }
    /// <p>Voice ID to use for the synthesis.</p>
    pub fn voice_id(&self) -> ::std::option::Option<&crate::types::VoiceId> {
        self.voice_id.as_ref()
    }
}
impl StartSpeechSynthesisTaskInput {
    /// Creates a new builder-style object to manufacture [`StartSpeechSynthesisTaskInput`](crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput).
    pub fn builder() -> crate::operation::start_speech_synthesis_task::builders::StartSpeechSynthesisTaskInputBuilder {
        crate::operation::start_speech_synthesis_task::builders::StartSpeechSynthesisTaskInputBuilder::default()
    }
}

/// A builder for [`StartSpeechSynthesisTaskInput`](crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartSpeechSynthesisTaskInputBuilder {
    pub(crate) engine: ::std::option::Option<crate::types::Engine>,
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) lexicon_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) output_format: ::std::option::Option<crate::types::OutputFormat>,
    pub(crate) output_s3_bucket_name: ::std::option::Option<::std::string::String>,
    pub(crate) output_s3_key_prefix: ::std::option::Option<::std::string::String>,
    pub(crate) sample_rate: ::std::option::Option<::std::string::String>,
    pub(crate) sns_topic_arn: ::std::option::Option<::std::string::String>,
    pub(crate) speech_mark_types: ::std::option::Option<::std::vec::Vec<crate::types::SpeechMarkType>>,
    pub(crate) text: ::std::option::Option<::std::string::String>,
    pub(crate) text_type: ::std::option::Option<crate::types::TextType>,
    pub(crate) voice_id: ::std::option::Option<crate::types::VoiceId>,
}
impl StartSpeechSynthesisTaskInputBuilder {
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn engine(mut self, input: crate::types::Engine) -> Self {
        self.engine = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn set_engine(mut self, input: ::std::option::Option<crate::types::Engine>) -> Self {
        self.engine = input;
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn get_engine(&self) -> &::std::option::Option<crate::types::Engine> {
        &self.engine
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// Appends an item to `lexicon_names`.
    ///
    /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
    ///
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub fn lexicon_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.lexicon_names.unwrap_or_default();
        v.push(input.into());
        self.lexicon_names = ::std::option::Option::Some(v);
        self
    }
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub fn set_lexicon_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.lexicon_names = input;
        self
    }
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub fn get_lexicon_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.lexicon_names
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    /// This field is required.
    pub fn output_format(mut self, input: crate::types::OutputFormat) -> Self {
        self.output_format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub fn set_output_format(mut self, input: ::std::option::Option<crate::types::OutputFormat>) -> Self {
        self.output_format = input;
        self
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub fn get_output_format(&self) -> &::std::option::Option<crate::types::OutputFormat> {
        &self.output_format
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    /// This field is required.
    pub fn output_s3_bucket_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.output_s3_bucket_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub fn set_output_s3_bucket_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.output_s3_bucket_name = input;
        self
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub fn get_output_s3_bucket_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.output_s3_bucket_name
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn output_s3_key_prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.output_s3_key_prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn set_output_s3_key_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.output_s3_key_prefix = input;
        self
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn get_output_s3_key_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.output_s3_key_prefix
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn sample_rate(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sample_rate = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn set_sample_rate(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sample_rate = input;
        self
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn get_sample_rate(&self) -> &::std::option::Option<::std::string::String> {
        &self.sample_rate
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn sns_topic_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sns_topic_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn set_sns_topic_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sns_topic_arn = input;
        self
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn get_sns_topic_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.sns_topic_arn
    }
    /// Appends an item to `speech_mark_types`.
    ///
    /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
    ///
    /// <p>The type of speech marks returned for the input text.</p>
    pub fn speech_mark_types(mut self, input: crate::types::SpeechMarkType) -> Self {
        let mut v = self.speech_mark_types.unwrap_or_default();
        v.push(input);
        self.speech_mark_types = ::std::option::Option::Some(v);
        self
    }
    /// <p>The type of speech marks returned for the input text.</p>
    pub fn set_speech_mark_types(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::SpeechMarkType>>) -> Self {
        self.speech_mark_types = input;
        self
    }
    /// <p>The type of speech marks returned for the input text.</p>
    pub fn get_speech_mark_types(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::SpeechMarkType>> {
        &self.speech_mark_types
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    /// This field is required.
    pub fn text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.text = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub fn set_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.text = input;
        self
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub fn get_text(&self) -> &::std::option::Option<::std::string::String> {
        &self.text
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn text_type(mut self, input: crate::types::TextType) -> Self {
        self.text_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn set_text_type(mut self, input: ::std::option::Option<crate::types::TextType>) -> Self {
        self.text_type = input;
        self
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn get_text_type(&self) -> &::std::option::Option<crate::types::TextType> {
        &self.text_type
    }
    /// <p>Voice ID to use for the synthesis.</p>
    /// This field is required.
    pub fn voice_id(mut self, input: crate::types::VoiceId) -> Self {
        self.voice_id = ::std::option::Option::Some(input);
        self
    }
    /// <p>Voice ID to use for the synthesis.</p>
    pub fn set_voice_id(mut self, input: ::std::option::Option<crate::types::VoiceId>) -> Self {
        self.voice_id = input;
        self
    }
    /// <p>Voice ID to use for the synthesis.</p>
    pub fn get_voice_id(&self) -> &::std::option::Option<crate::types::VoiceId> {
        &self.voice_id
    }
    /// Consumes the builder and constructs a [`StartSpeechSynthesisTaskInput`](crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput {
            engine: self.engine,
            language_code: self.language_code,
            lexicon_names: self.lexicon_names,
            output_format: self.output_format,
            output_s3_bucket_name: self.output_s3_bucket_name,
            output_s3_key_prefix: self.output_s3_key_prefix,
            sample_rate: self.sample_rate,
            sns_topic_arn: self.sns_topic_arn,
            speech_mark_types: self.speech_mark_types,
            text: self.text,
            text_type: self.text_type,
            voice_id: self.voice_id,
        })
    }
}
