// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the condition that streams must satisfy to be returned when you list streams (see the <code>ListStreams</code> API). A condition has a comparison operation and a value. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StreamNameCondition {
    /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>
    pub comparison_operator: ::std::option::Option<crate::types::ComparisonOperator>,
    /// <p>A value to compare.</p>
    pub comparison_value: ::std::option::Option<::std::string::String>,
}
impl StreamNameCondition {
    /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>
    pub fn comparison_operator(&self) -> ::std::option::Option<&crate::types::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>A value to compare.</p>
    pub fn comparison_value(&self) -> ::std::option::Option<&str> {
        self.comparison_value.as_deref()
    }
}
impl StreamNameCondition {
    /// Creates a new builder-style object to manufacture [`StreamNameCondition`](crate::types::StreamNameCondition).
    pub fn builder() -> crate::types::builders::StreamNameConditionBuilder {
        crate::types::builders::StreamNameConditionBuilder::default()
    }
}

/// A builder for [`StreamNameCondition`](crate::types::StreamNameCondition).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StreamNameConditionBuilder {
    pub(crate) comparison_operator: ::std::option::Option<crate::types::ComparisonOperator>,
    pub(crate) comparison_value: ::std::option::Option<::std::string::String>,
}
impl StreamNameConditionBuilder {
    /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>
    pub fn comparison_operator(mut self, input: crate::types::ComparisonOperator) -> Self {
        self.comparison_operator = ::std::option::Option::Some(input);
        self
    }
    /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>
    pub fn set_comparison_operator(mut self, input: ::std::option::Option<crate::types::ComparisonOperator>) -> Self {
        self.comparison_operator = input;
        self
    }
    /// <p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>
    pub fn get_comparison_operator(&self) -> &::std::option::Option<crate::types::ComparisonOperator> {
        &self.comparison_operator
    }
    /// <p>A value to compare.</p>
    pub fn comparison_value(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.comparison_value = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A value to compare.</p>
    pub fn set_comparison_value(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.comparison_value = input;
        self
    }
    /// <p>A value to compare.</p>
    pub fn get_comparison_value(&self) -> &::std::option::Option<::std::string::String> {
        &self.comparison_value
    }
    /// Consumes the builder and constructs a [`StreamNameCondition`](crate::types::StreamNameCondition).
    pub fn build(self) -> crate::types::StreamNameCondition {
        crate::types::StreamNameCondition {
            comparison_operator: self.comparison_operator,
            comparison_value: self.comparison_value,
        }
    }
}
