// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The structure that contains the notification information for the KVS images delivery. If this parameter is null, the configuration will be deleted from the stream.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct NotificationConfiguration {
    /// <p>Indicates if a notification configuration is enabled or disabled.</p>
    pub status: crate::types::ConfigurationStatus,
    /// <p>The destination information required to deliver a notification to a customer.</p>
    pub destination_config: ::std::option::Option<crate::types::NotificationDestinationConfig>,
}
impl NotificationConfiguration {
    /// <p>Indicates if a notification configuration is enabled or disabled.</p>
    pub fn status(&self) -> &crate::types::ConfigurationStatus {
        &self.status
    }
    /// <p>The destination information required to deliver a notification to a customer.</p>
    pub fn destination_config(&self) -> ::std::option::Option<&crate::types::NotificationDestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::types::NotificationConfiguration).
    pub fn builder() -> crate::types::builders::NotificationConfigurationBuilder {
        crate::types::builders::NotificationConfigurationBuilder::default()
    }
}

/// A builder for [`NotificationConfiguration`](crate::types::NotificationConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct NotificationConfigurationBuilder {
    pub(crate) status: ::std::option::Option<crate::types::ConfigurationStatus>,
    pub(crate) destination_config: ::std::option::Option<crate::types::NotificationDestinationConfig>,
}
impl NotificationConfigurationBuilder {
    /// <p>Indicates if a notification configuration is enabled or disabled.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::ConfigurationStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates if a notification configuration is enabled or disabled.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::ConfigurationStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>Indicates if a notification configuration is enabled or disabled.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::ConfigurationStatus> {
        &self.status
    }
    /// <p>The destination information required to deliver a notification to a customer.</p>
    /// This field is required.
    pub fn destination_config(mut self, input: crate::types::NotificationDestinationConfig) -> Self {
        self.destination_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The destination information required to deliver a notification to a customer.</p>
    pub fn set_destination_config(mut self, input: ::std::option::Option<crate::types::NotificationDestinationConfig>) -> Self {
        self.destination_config = input;
        self
    }
    /// <p>The destination information required to deliver a notification to a customer.</p>
    pub fn get_destination_config(&self) -> &::std::option::Option<crate::types::NotificationDestinationConfig> {
        &self.destination_config
    }
    /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::types::NotificationConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::NotificationConfigurationBuilder::status)
    pub fn build(self) -> ::std::result::Result<crate::types::NotificationConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::NotificationConfiguration {
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building NotificationConfiguration",
                )
            })?,
            destination_config: self.destination_config,
        })
    }
}
