// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The configuration details required to delete the connection of the stream from the Edge Agent.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeletionConfig {
    /// <p>The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the retention time is 720 hours, which translates to 30 days.</p>
    pub edge_retention_in_hours: ::std::option::Option<i32>,
    /// <p>The value of the local size required in order to delete the edge configuration.</p>
    pub local_size_config: ::std::option::Option<crate::types::LocalSizeConfig>,
    /// <p>The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion configuration values are set to <code>true</code>, such as when the limit for the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.</p>
    /// <p>Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.</p>
    pub delete_after_upload: ::std::option::Option<bool>,
}
impl DeletionConfig {
    /// <p>The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the retention time is 720 hours, which translates to 30 days.</p>
    pub fn edge_retention_in_hours(&self) -> ::std::option::Option<i32> {
        self.edge_retention_in_hours
    }
    /// <p>The value of the local size required in order to delete the edge configuration.</p>
    pub fn local_size_config(&self) -> ::std::option::Option<&crate::types::LocalSizeConfig> {
        self.local_size_config.as_ref()
    }
    /// <p>The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion configuration values are set to <code>true</code>, such as when the limit for the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.</p>
    /// <p>Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.</p>
    pub fn delete_after_upload(&self) -> ::std::option::Option<bool> {
        self.delete_after_upload
    }
}
impl DeletionConfig {
    /// Creates a new builder-style object to manufacture [`DeletionConfig`](crate::types::DeletionConfig).
    pub fn builder() -> crate::types::builders::DeletionConfigBuilder {
        crate::types::builders::DeletionConfigBuilder::default()
    }
}

/// A builder for [`DeletionConfig`](crate::types::DeletionConfig).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DeletionConfigBuilder {
    pub(crate) edge_retention_in_hours: ::std::option::Option<i32>,
    pub(crate) local_size_config: ::std::option::Option<crate::types::LocalSizeConfig>,
    pub(crate) delete_after_upload: ::std::option::Option<bool>,
}
impl DeletionConfigBuilder {
    /// <p>The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the retention time is 720 hours, which translates to 30 days.</p>
    pub fn edge_retention_in_hours(mut self, input: i32) -> Self {
        self.edge_retention_in_hours = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the retention time is 720 hours, which translates to 30 days.</p>
    pub fn set_edge_retention_in_hours(mut self, input: ::std::option::Option<i32>) -> Self {
        self.edge_retention_in_hours = input;
        self
    }
    /// <p>The number of hours that you want to retain the data in the stream on the Edge Agent. The default value of the retention time is 720 hours, which translates to 30 days.</p>
    pub fn get_edge_retention_in_hours(&self) -> &::std::option::Option<i32> {
        &self.edge_retention_in_hours
    }
    /// <p>The value of the local size required in order to delete the edge configuration.</p>
    pub fn local_size_config(mut self, input: crate::types::LocalSizeConfig) -> Self {
        self.local_size_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>The value of the local size required in order to delete the edge configuration.</p>
    pub fn set_local_size_config(mut self, input: ::std::option::Option<crate::types::LocalSizeConfig>) -> Self {
        self.local_size_config = input;
        self
    }
    /// <p>The value of the local size required in order to delete the edge configuration.</p>
    pub fn get_local_size_config(&self) -> &::std::option::Option<crate::types::LocalSizeConfig> {
        &self.local_size_config
    }
    /// <p>The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion configuration values are set to <code>true</code>, such as when the limit for the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.</p>
    /// <p>Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.</p>
    pub fn delete_after_upload(mut self, input: bool) -> Self {
        self.delete_after_upload = ::std::option::Option::Some(input);
        self
    }
    /// <p>The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion configuration values are set to <code>true</code>, such as when the limit for the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.</p>
    /// <p>Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.</p>
    pub fn set_delete_after_upload(mut self, input: ::std::option::Option<bool>) -> Self {
        self.delete_after_upload = input;
        self
    }
    /// <p>The <code>boolean</code> value used to indicate whether or not you want to mark the media for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The media files can be deleted if any of the deletion configuration values are set to <code>true</code>, such as when the limit for the <code>EdgeRetentionInHours</code>, or the <code>MaxLocalMediaSizeInMB</code>, has been reached.</p>
    /// <p>Since the default value is set to <code>true</code>, configure the uploader schedule such that the media files are not being deleted before they are initially uploaded to the Amazon Web Services cloud.</p>
    pub fn get_delete_after_upload(&self) -> &::std::option::Option<bool> {
        &self.delete_after_upload
    }
    /// Consumes the builder and constructs a [`DeletionConfig`](crate::types::DeletionConfig).
    pub fn build(self) -> crate::types::DeletionConfig {
        crate::types::DeletionConfig {
            edge_retention_in_hours: self.edge_retention_in_hours,
            local_size_config: self.local_size_config,
            delete_after_upload: self.delete_after_upload,
        }
    }
}
