// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`UpdateStream`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the stream whose metadata you want to update.</p> <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The ARN of the stream whose metadata you want to update.</p><br>
    ///   - [`current_version(impl Into<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::current_version) / [`set_current_version(Option<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::set_current_version):<br>required: **true**<br><p>The version of the stream whose metadata you want to update.</p><br>
    ///   - [`device_name(impl Into<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::device_name) / [`set_device_name(Option<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::set_device_name):<br>required: **false**<br><p>The name of the device that is writing to the stream.</p><note>  <p>In the current implementation, Kinesis Video Streams does not use this name.</p> </note><br>
    ///   - [`media_type(impl Into<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::media_type) / [`set_media_type(Option<String>)`](crate::operation::update_stream::builders::UpdateStreamFluentBuilder::set_media_type):<br>required: **false**<br><p>The stream's media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p> <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p><br>
    /// - On success, responds with [`UpdateStreamOutput`](crate::operation::update_stream::UpdateStreamOutput)
    /// - On failure, responds with [`SdkError<UpdateStreamError>`](crate::operation::update_stream::UpdateStreamError)
    pub fn update_stream(&self) -> crate::operation::update_stream::builders::UpdateStreamFluentBuilder {
        crate::operation::update_stream::builders::UpdateStreamFluentBuilder::new(self.handle.clone())
    }
}
