// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartEdgeConfigurationUpdate`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the stream whose edge configuration you want to update. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p><br>
    ///   - [`edge_config(EdgeConfig)`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::edge_config) / [`set_edge_config(Option<EdgeConfig>)`](crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::set_edge_config):<br>required: **true**<br><p>The edge configuration details required to invoke the update process.</p><br>
    /// - On success, responds with [`StartEdgeConfigurationUpdateOutput`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput) with field(s):
    ///   - [`stream_name(Option<String>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::stream_name): <p>The name of the stream from which the edge configuration was updated.</p>
    ///   - [`stream_arn(Option<String>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::stream_arn): <p>The Amazon Resource Name (ARN) of the stream.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::creation_time): <p>The timestamp at which a stream’s edge configuration was first created.</p>
    ///   - [`last_updated_time(Option<DateTime>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::last_updated_time): <p>The timestamp at which a stream’s edge configuration was last updated.</p>
    ///   - [`sync_status(Option<SyncStatus>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::sync_status): <p>The current sync status of the stream's edge configuration. When you invoke this API, the sync status will be set to the <code>SYNCING</code> state. Use the <code>DescribeEdgeConfiguration</code> API to get the latest status of the edge configuration.</p>
    ///   - [`failed_status_details(Option<String>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::failed_status_details): <p>A description of the generated failure status.</p>
    ///   - [`edge_config(Option<EdgeConfig>)`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateOutput::edge_config): <p>A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass component. The Edge Agent component will run on an IoT Hub Device setup at your premise.</p>
    /// - On failure, responds with [`SdkError<StartEdgeConfigurationUpdateError>`](crate::operation::start_edge_configuration_update::StartEdgeConfigurationUpdateError)
    pub fn start_edge_configuration_update(
        &self,
    ) -> crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder {
        crate::operation::start_edge_configuration_update::builders::StartEdgeConfigurationUpdateFluentBuilder::new(self.handle.clone())
    }
}
