```toml
[advisory]
id = "CVE-2018-1000810"
package = "std"
categories = ["denial-of-service", "memory-corruption"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2018-09-21"
url = "https://groups.google.com/forum/#!topic/rustlang-security-announcements/CmSuTm-SaU0"

[affected.functions]
"std::str::repeat" = ["< 1.29.1, >= 1.26.0"]

[versions]
patched = [">= 1.29.1"]
unaffected = ["< 1.26.0"]
```

# Buffer overflow vulnerability in str::repeat()

The Rust team was recently notified of a security vulnerability affecting
the `str::repeat` function in the standard library. If your code does not
use this function, it is not affected.

## Overview

This vulnerability is an instance of CWE-680: Integer Overflow to Buffer
Overflow[1].

The `str::repeat` function in the standard library allows repeating a
string a fixed number of times, returning an owned version of the final
string. The capacity of the final string is calculated by multiplying
the length of the string being repeated by the number of copies. This
calculation can overflow, and this case was not properly checked for.

The rest of the implementation of `str::repeat` contains unsafe code
that relies on a preallocated vector having the capacity calculated
earlier. On integer overflow the capacity will be less than required,
and which then writes outside of the allocated buffer, leading to
buffer overflow.

## Affected Versions

While the `str::repeat` function has been in Rust since 1.16.0, this
vulnerability was introduced into the standard library in pull
request #48657 [2]. The pull request was merged on March 6, 2018 and
was first part of the 1.26.0 stable released on May 10, 2018.

As such, this vulnerability affects:

* Every nightly we've produced since March 6, 2018
* Every beta produced since March 6, 2018
* These specific Rust releases:
  * 1.29.0
  * 1.28.0
  * 1.27.2
  * 1.27.1
  * 1.27.0
  * 1.26.2
  * 1.26.1
  * 1.26.0

## Mitigations

This bug can be mitigated manually by auditing for calls to `str::repeat`
and testing if the resulting vector's capacity will overflow. If it does,
then the program should panic.

For Rust 1.29, we'll be releasing a 1.29.1 on 2018-09-25 with the fix,
which consists of checking for overflow and deterministically panicking
if it happens. Nightlies and betas produced after 2019-09-21 will also
contain a fix for this issue.

We will not be releasing our own fixes for previous versions of Rust.
The patch to fix 1.29 should roughly applicable to older versions, although
the implementation has seen a few refactorings since it was introduced.
The patch for 1.29 is included at the end of this email. If you
need assistance patching an older version of Rust on your own, please reach
out to our security mailing list, security@rust-lang.org, and we'll be happy
to help.

The current beta and nightly channels will be updated with a fix for this
issue as well.

## Timeline of events

* Sun, Sep 16, 2018 at 20:24 PM - Bug reported to security@rust-lang.org
* Mon, Sep 17, 2018 at 14:19 PM - Steve responds, confirming the bug
* Tue, Sep 18, 2018 - Steve works up an initial patch
* Wed, Sep 19, 2018 - Core team confirms 1.29.1 release date
* Thu, Sep 20, 2018 - PRs posted to GitHub for
stable[3]/beta[4]/master[5] branches
* Fri, Sep 21, 2018 - Security list informed of this issue
* (planned) Tue, Sep 25, 2018 - Rust 1.29.1 is released with a fix for
this issue

## Acknowledgements

Thanks to Scott McMurray, who found this bug and reported it to us in
accordance with our security policy https://www.rust-lang.org/security.html.

[1]: https://cwe.mitre.org/data/definitions/680.html
[2]: https://github.com/rust-lang/rust/pull/48657
[3]: https://github.com/rust-lang/rust/pull/54397
[4]: https://github.com/rust-lang/rust/pull/54398
[5]: https://github.com/rust-lang/rust/pull/54399
