```toml
[advisory]
id = "RUSTSEC-2024-0346"
package = "zerovec-derive"
date = "2024-07-01"
categories = ["memory-corruption"]

[versions]
patched = [">= 0.10.3", ">= 0.9.7, <0.10.0"]
```

# Incorrect usage of `#[repr(packed)]`

The affected versions make unsafe memory accesses under the assumption that `#[repr(packed)]` has a guaranteed field order. 

The Rust specification does not guarantee this, and https://github.com/rust-lang/rust/pull/125360 (1.80.0-beta) starts 
reordering fields of `#[repr(packed)]` structs, leading to illegal memory accesses.

The patched versions `0.9.7` and `0.10.3` use `#[repr(C, packed)]`, which guarantees field order.
