```toml
[advisory]
id = "RUSTSEC-2024-0360"
package = "xmp_toolkit"
date = "2024-07-26"
url = "https://github.com/adobe/xmp-toolkit-rs/issues/233"
informational = "unsound"
keywords = ["xmp"]

[affected]
functions = { "xmp_toolkit::XmpFile::close" = ["< 1.9.0"] }

[versions]
patched = [">= 1.9.0"]
```

# `XmpFile::close` can trigger UB

Affected versions of the crate failed to catch C++ exceptions raised within the `XmpFile::close` function. If such an exception occured, it would trigger undefined behavior, typically a process abort.

This is best demonstrated in [issue #230](https://github.com/adobe/xmp-toolkit-rs/issues/230), where a race condition causes the `close` call to fail due to file I/O errors.

This was fixed in [PR #232](https://github.com/adobe/xmp-toolkit-rs/pull/232) (released as crate version 1.9.0), which now safely handles the exception.

For backward compatibility, the existing API ignores the error. A new API `XmpFile::try_close` was added to allow callers to receive and process the error result.

Users of all prior versions of `xmp_toolkit` are encouraged to update to version 1.9.0 to avoid undefined behavior.
