```toml
[advisory]
id = "RUSTSEC-2022-0008"
package = "windows"
date = "2022-01-02"
url = "https://github.com/microsoft/windows-rs/issues/1409"
categories = ["memory-corruption", "thread-safety"]
keywords = []
informational = "unsound"
aliases = ["GHSA-x4mq-m75f-mx8m"]

[versions]
patched = [">= 0.32.0"]
unaffected = ["< 0.1.2"]

[affected]
os = ["windows"]
```

# Delegate functions are missing `Send` bound

Affected versions of this crate did not require event handlers to have `Send` bound despite there being no guarantee of them being called on any particular thread, which can potentially lead to data races and undefined behavior.

The flaw was corrected in commit [afe3252](https://github.com/microsoft/windows-rs/commit/afe32525c22209aa8f632a0f4ad607863b51796a) by adding `Send` bounds.
