```toml
[advisory]
id = "RUSTSEC-2022-0076"
package = "wasmtime"
date = "2022-11-10"
url = "https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-44mr-8vmm-wjhg"
references = ["https://github.com/bytecodealliance/wasmtime/commit/e60c3742904ccbb3e26da201c9221c38a4981d72"]
categories = ["memory-corruption", "memory-exposure"]
keywords = ["memory", "allocator", "Wasm", "bounds", "sandbox", "paging"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N"
aliases = ["CVE-2022-39392", "GHSA-44mr-8vmm-wjhg"]

[versions]
patched = [">= 1.0.2, < 2.0.0", ">= 2.0.2"]

[affected.functions]
"wasmtime::PoolingAllocationConfig::instance_memory_pages" = [">= 2.0.0, < 2.0.2"]
"wasmtime::Config::allocation_strategy" = ["< 1.0.2"]
```

# Bug in Wasmtime implementation of pooling instance allocator

Bug in Wasmtime's implementation of its pooling instance allocator when the allocator is configured to give WebAssembly instances a maximum of zero pages of memory.

In this configuration, the virtual memory mapping for WebAssembly memories did not meet the compiler-required configuration requirements for safely executing WebAssembly modules. Wasmtime's default settings require virtual memory page faults to indicate that wasm reads/writes are out-of-bounds, but the pooling allocator's configuration would not create an appropriate virtual memory mapping for this meaning out of bounds reads/writes can successfully read/write memory unrelated to the wasm sandbox within range of the base address of the memory mapping created by the pooling allocator.

This bug is not applicable with the default settings of the `wasmtime` crate.

This bug can only be triggered by setting `InstanceLimits::memory_pages` to zero.

This is expected to be a very rare configuration since this means that wasm modules cannot allocate any pages of linear memory.

All wasm modules produced by all current toolchains are highly likely to use linear memory, so it's expected to be unlikely that this configuration is set to zero by any production embedding of Wasmtime.
