```toml
[advisory]
id = "RUSTSEC-2024-0342"
package = "vodozemac"
date = "2024-05-02"
url = "https://github.com/matrix-org/vodozemac/security/advisories/GHSA-c3hm-hxwf-g5c6"
categories = ["memory-exposure"]
aliases = ["CVE-2024-34063", "GHSA-c3hm-hxwf-g5c6"]

[versions]
patched = [">= 0.6.0"]
unaffected = ["< 0.5.0"]
```

# Degraded secret zeroization capabilities 

Versions 0.5.0 and 0.5.1 of vodozemac have degraded secret zeroization capabilities,
due to changes in third-party cryptographic dependencies (the Dalek crates),
which moved secret zeroization capabilities behind a feature flag while
vodozemac disabled the default feature set.

## Impact

The degraded zeroization capabilities could result in the production of more
memory copies of encryption secrets and secrets could linger in memory longer
than necessary. This marginally increases the risk of sensitive data exposure.

Overall, we consider the impact of this issue to be low. Although cryptographic
best practices recommend the clearing of sensitive information from memory once
it's no longer needed, the inherent limitations of Rust regarding absolute
zeroization reduce the practical severity of this lapse.
