```toml
[advisory]
id = "RUSTSEC-2021-0043"
package = "uu_od"
aliases = ["CVE-2021-29934", "GHSA-w9vv-q986-vj7x"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L"
date = "2021-02-17"
url = "https://github.com/uutils/coreutils/issues/1729"
categories = ["memory-exposure"]

[versions]
patched = [">= 0.0.4"]
```

# PartialReader passes uninitialized memory to user-provided Read

Affected versions of this crate passed an uniniitalized buffer to a
user-provided `Read` instance in `PartialReader::read`.

This can result in safe `Read` implementations reading from the uninitialized
buffer leading to undefined behavior.

The flaw was fixed in commit [`39d62c6`](https://github.com/uutils/coreutils/commit/39d62c6c1f809022c903180471c10fde6ecd12d1)
by zero-initializing the passed buffer.
